/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.servlet;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.servlet.ServletContextRuntimeException;

public class FileNameResolver {
    protected final ServletContext servletContext;
    protected final String contextRootPath;

    public FileNameResolver(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.contextRootPath = servletContext.getRealPath("/");
    }

    public String toRealPath(String path) {
        if (this.servletContext == null) {
            throw new ServletContextRuntimeException("servletContext is null!! ");
        }
        if (StringUtils.isEmpty((String)path)) {
            return this.contextRootPath;
        }
        File origPathFile = new File(path);
        if (origPathFile.exists()) {
            this.servletContext.log(String.valueOf(this.getClass().getName()) + ": '" + path + "' exists.");
            return path;
        }
        if (origPathFile.isAbsolute()) {
            this.servletContext.log(String.valueOf(this.getClass().getName()) + ": '" + path + "' is an absolute path, but doesn't exist.");
            return path;
        }
        String realPath = FileNameUtils.toAbsolutePath(this.contextRootPath, path);
        this.servletContext.log(String.valueOf(this.getClass().getName()) + ": '" + path + "' ----> '" + realPath + "'");
        return realPath;
    }

    public String getContextRootPath() {
        return this.contextRootPath;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

