/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.asyrinx.brownie.swing.AbsoluteConstraints;

public class AbsoluteLayout
implements LayoutManager2,
Serializable {
    protected final Map constraintMap = new Hashtable();

    public void addLayoutComponent(Component component, Object obj) {
        if (!(obj instanceof AbsoluteConstraints)) {
            throw new IllegalArgumentException();
        }
        this.constraintMap.put(component, obj);
    }

    public void addLayoutComponent(String s, Component component) {
        throw new IllegalArgumentException();
    }

    public void removeLayoutComponent(Component component) {
        this.constraintMap.remove(component);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Iterator iterator = this.constraintMap.keySet().iterator();
        while (iterator.hasNext()) {
            int j;
            Component component = (Component)iterator.next();
            AbsoluteConstraints constraints = (AbsoluteConstraints)this.constraintMap.get(component);
            Dimension dimension = component.getPreferredSize();
            int i = constraints.getWidth();
            if (i == -1) {
                i = dimension.width;
            }
            if ((j = constraints.getHeight()) == -1) {
                j = dimension.height;
            }
            component.setBounds(constraints.x, constraints.y, i, j);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        int i = 0;
        int j = 0;
        Iterator iterator = this.constraintMap.keySet().iterator();
        while (iterator.hasNext()) {
            int l;
            Component component = (Component)iterator.next();
            AbsoluteConstraints constraints = (AbsoluteConstraints)this.constraintMap.get(component);
            Dimension dimension = component.getMinimumSize();
            int k = constraints.getWidth();
            if (k == -1) {
                k = dimension.width;
            }
            if ((l = constraints.getHeight()) == -1) {
                l = dimension.height;
            }
            if (constraints.x + k > i) {
                i = constraints.x + k;
            }
            if (constraints.y + l <= j) continue;
            j = constraints.y + l;
        }
        return new Dimension(i, j);
    }

    public Dimension preferredLayoutSize(Container container) {
        int i = 0;
        int j = 0;
        Iterator iterator = this.constraintMap.keySet().iterator();
        while (iterator.hasNext()) {
            int l;
            Component component = (Component)iterator.next();
            AbsoluteConstraints absoluteconstraints = (AbsoluteConstraints)this.constraintMap.get(component);
            Dimension dimension = component.getPreferredSize();
            int k = absoluteconstraints.getWidth();
            if (k == -1) {
                k = dimension.width;
            }
            if ((l = absoluteconstraints.getHeight()) == -1) {
                l = dimension.height;
            }
            if (absoluteconstraints.x + k > i) {
                i = absoluteconstraints.x + k;
            }
            if (absoluteconstraints.y + l <= j) continue;
            j = absoluteconstraints.y + l;
        }
        return new Dimension(i, j);
    }
}

