/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.content;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.asyrinx.brownie.swing.GuiRuntimeException;
import org.asyrinx.brownie.swing.content.WindowContent;

public class ContentDialog
extends JDialog {
    protected final Component content;

    public ContentDialog(Component content, Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.content = content;
        this.intiPane();
    }

    public ContentDialog(Component content, Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.content = content;
        this.intiPane();
    }

    public static ContentDialog create(Component content, Component owner, String title, boolean modal) {
        if (owner instanceof Frame) {
            return new ContentDialog(content, (Frame)owner, title, modal);
        }
        if (owner instanceof Dialog) {
            return new ContentDialog(content, (Dialog)owner, title, modal);
        }
        Window window = SwingUtilities.getWindowAncestor(owner);
        if (window instanceof Frame) {
            return new ContentDialog(content, (Frame)window, title, modal);
        }
        if (window instanceof Dialog) {
            return new ContentDialog(content, (Dialog)window, title, modal);
        }
        throw new GuiRuntimeException("owner and its window don't extended Frame or Dialog.");
    }

    protected void intiPane() {
        if (this.content instanceof Container) {
            this.setContentPane((Container)this.content);
        } else {
            JPanel panel = new JPanel();
            panel.add(this.content);
            this.setContentPane(panel);
        }
    }

    public void show() {
        this.invokeBeforeShow();
        super.show();
        this.invokeAfterShow();
    }

    protected void invokeBeforeShow() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).beforeShow();
        }
    }

    protected void invokeAfterShow() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).afterShow();
        }
    }

    public void hide() {
        this.invokeBeforeHide();
        super.hide();
        this.invokeAfterHide();
    }

    protected void invokeBeforeHide() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).beforeHide();
        }
    }

    protected void invokeAfterHide() {
        if (this.content instanceof WindowContent) {
            ((WindowContent)((Object)this.content)).afterHide();
        }
    }
}

