/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table.calc;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import org.asyrinx.brownie.core.collection.calc.Calculation;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.swing.table.calc.CalcColumnImpl;
import org.asyrinx.brownie.swing.table.calc.CalcTableModel;
import org.asyrinx.brownie.swing.table.key.Column;
import org.asyrinx.brownie.swing.table.key.KeyColumn;
import org.asyrinx.brownie.swing.table.key.KeyColumnTableModel;
import org.asyrinx.brownie.swing.table.key.RowKey;
import org.asyrinx.brownie.swing.table.key.RowKeyContainer;

public class CalcTableModelImpl
extends KeyColumnTableModel
implements CalcTableModel,
RowKeyContainer {
    private final List calcColumns = new ArrayList();
    private final List columns = new ArrayList();

    public CalcTableModelImpl(TableModel tableModel) {
        super(tableModel);
        this.initEventListener();
    }

    public CalcTableModelImpl(TableModel tableModel, int[] keyColumns) {
        super(tableModel, keyColumns);
        this.initKeyColumns(keyColumns);
        this.refreshKeys();
        this.initEventListener();
    }

    public void refreshKeys() {
        this.clearKeyList();
        int r = 0;
        while (r < this.tableModel.getRowCount()) {
            Object[] values = new Object[this.getKeyColumnCount()];
            int i = 0;
            while (i < this.getKeyColumnCount()) {
                KeyColumn column = this.getKeyColumn(i);
                Object value = this.tableModel.getValueAt(r, column.getOriginalColumnIndex());
                values[i] = NumberUtils.isNumber(value) ? NumberUtils.toNumber(value) : value;
                ++i;
            }
            RowKey exists = this.findKey(values);
            RowKey current = new RowKey(values);
            if (exists == null) {
                this.addRowKey(current);
                current.addTargetRowIndex(r);
            } else {
                exists.addTargetRowIndex(r);
            }
            ++r;
        }
    }

    public int getCalcColumnCount() {
        return this.calcColumns.size();
    }

    protected void addKeyColumn(KeyColumn keyColumn) {
        this.columns.add(keyColumn);
        super.addKeyColumn(keyColumn);
    }

    public void addCalcColumn(int originalColumnIndex, Calculation calculation) {
        this.addCalcColumn(originalColumnIndex, calculation, null);
    }

    public void addCalcColumn(int originalColumnIndex, Calculation calculation, String name) {
        this.addColumn(new CalcColumnImpl(originalColumnIndex, this.tableModel, this, calculation, name));
    }

    protected void addColumn(CalcColumnImpl calcColumn) {
        this.calcColumns.add(calcColumn);
        this.columns.add(calcColumn);
        this.fireTableStructureChanged();
    }

    public Column getColumn(int columnIndex) {
        return (Column)this.columns.get(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        Column columnModel = this.getColumn(columnIndex);
        return columnModel == null ? null : columnModel.getColumnClass();
    }

    public int getColumnCount() {
        return this.getKeyColumnCount() + this.getCalcColumnCount();
    }

    public String getColumnName(int columnIndex) {
        Column columnModel = this.getColumn(columnIndex);
        return columnModel == null ? null : columnModel.getColumnName();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Column columnModel = this.getColumn(columnIndex);
        return columnModel == null ? null : columnModel.getValueAt(rowIndex);
    }
}

