/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.link;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.ILinkRenderer;
import org.asyrinx.brownie.tapestry.script.ScriptUtils;

public abstract class AbstractScriptLinkRenderer
implements ILinkRenderer {
    private final String scriptName;
    private IScript script = null;

    public AbstractScriptLinkRenderer(String scriptName) {
        this.scriptName = scriptName;
    }

    protected IScript loadScript(ILinkComponent linkComponent) {
        if (this.script == null) {
            this.script = ScriptUtils.loadScript((IComponent)linkComponent, this.getScriptName());
        }
        return this.script;
    }

    protected String getScriptName() {
        return this.scriptName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderLink(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent linkComponent) {
        this.checkBeforeRender(cycle, linkComponent);
        cycle.setAttribute("org.apache.tapestry.active-link-component", (Object)linkComponent);
        try {
            IMarkupWriter wrappedWriter;
            IScript loadedScript = this.loadScript(linkComponent);
            boolean hasBody = this.getHasBody();
            boolean disabled = linkComponent.isDisabled();
            if (!cycle.isRewinding()) {
                Body body = Body.get((IRequestCycle)cycle);
                if (!disabled) {
                    this.addScript(cycle, loadedScript, body);
                }
                this.renderBeginTag(writer, cycle, linkComponent);
            }
            IMarkupWriter iMarkupWriter = wrappedWriter = !disabled ? writer.getNestedWriter() : writer;
            if (hasBody) {
                this.renderBody(wrappedWriter, cycle, linkComponent);
                linkComponent.renderBody(wrappedWriter, cycle);
            }
            if (!cycle.isRewinding()) {
                linkComponent.renderAdditionalAttributes(writer, cycle);
                if (hasBody) {
                    wrappedWriter.close();
                    writer.end();
                } else {
                    writer.closeTag();
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            cycle.removeAttribute("org.apache.tapestry.active-link-component");
            throw throwable;
        }
        cycle.removeAttribute("org.apache.tapestry.active-link-component");
    }

    protected void checkBeforeRender(IRequestCycle cycle, ILinkComponent linkComponent) {
        Body body;
        if (cycle.getAttribute("org.apache.tapestry.active-link-component") != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage((String)"AbstractLinkComponent.no-nesting"), (Object)linkComponent, null, null);
        }
        if (!cycle.isRewinding() && (body = Body.get((IRequestCycle)cycle)) == null) {
            throw new ApplicationRuntimeException("must-be-contained-by-body", (Object)this, null, null);
        }
    }

    protected final String constructURL(ILink link, String anchor) {
        return link.getURL(anchor, true);
    }

    protected boolean getHasBody() {
        return true;
    }

    protected abstract void addScript(IRequestCycle var1, IScript var2, Body var3);

    protected abstract void renderBeginTag(IMarkupWriter var1, IRequestCycle var2, ILinkComponent var3);

    protected abstract void renderBody(IMarkupWriter var1, IRequestCycle var2, ILinkComponent var3);
}

