/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/29
 */
package org.asyrinx.joey.om;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;

import org.apache.commons.lang.StringUtils;

/**
 * @author akima
 */
public abstract class AbstractSearchCondition implements SearchCondition {

	/**
	 *  
	 */
	public AbstractSearchCondition() {
		super();
	}

	private int maxRecordCount = 10;

	private DateFormat dateFormat = new SimpleDateFormat();

	protected ConditionTranslator translater;

	abstract protected void prepare();

	/**
	 * 
	 * @see org.asyrinx.joey.om.SearchCondition#attach(org.asyrinx.joey.om.ConditionTranslator)
	 */
	public void attach(ConditionTranslator conditionTranslater) {
		this.translater = conditionTranslater;
		try {
			prepare();
		} finally {
			this.translater = null;
		}
	}

	/**
	 * 
	 * @see org.asyrinx.joey.om.SearchCondition#getMaxRecordCount()
	 */
	public int getMaxRecordCount() {
		return maxRecordCount;
	}

	/**
	 * 
	 * @see org.asyrinx.joey.om.SearchCondition#setMaxRecordCount(int)
	 */
	public void setMaxRecordCount(int i) {
		maxRecordCount = i;
	}

	protected final void addFrom(String tableName) {
		if (StringUtils.isEmpty(tableName))
			return;
		translater.addFrom(tableName);
	}

	private boolean isAvailableValue(Object value) {
		if (value == null)
			return false;
		if (value instanceof String)
			return ((String) value).length() > 0;
		if (value instanceof Collection)
			return !((Collection) value).isEmpty();
		return true;
	}

	protected final void addInt(String fieldName, Object value, Object operator) {
		if (StringUtils.isEmpty(fieldName))
			return;
		if (!isAvailableValue(value))
			return;
		translater.addInt(fieldName, value, operator);
	}

	protected final void addInt(String fieldName, String value) {
		addInt(fieldName, value, EQUAL);
	}

	protected final void addIntMin(String fieldName, String value) {
		addInt(fieldName, value, GREATER_EQUAL);
	}

	protected final void addIntMax(String fieldName, String value) {
		addInt(fieldName, value, LESS_EQUAL);
	}

	protected final void addLong(String fieldName, Object value, Object operator) {
		if (StringUtils.isEmpty(fieldName))
			return;
		if (!isAvailableValue(value))
			return;
		translater.addLong(fieldName, value, operator);
	}

	protected final void addLong(String fieldName, String value) {
		addLong(fieldName, value, EQUAL);
	}

	protected final void addLongMin(String fieldName, String value) {
		addLong(fieldName, value, GREATER_EQUAL);
	}

	protected final void addLongMax(String fieldName, String value) {
		addLong(fieldName, value, LESS_EQUAL);
	}

	protected final void addDate(String fieldName, Object value,
			Object operator, DateFormat format) {
		if (StringUtils.isEmpty(fieldName))
			return;
		if (!isAvailableValue(value))
			return;
		translater.addDate(fieldName, value, operator, format);
	}

	protected final void addDate(String fieldName, Object value, Object operator) {
		addDate(fieldName, value, operator, getDateFormat());
	}

	protected final void addDate(String fieldName, String value) {
		addDate(fieldName, value, EQUAL);
	}

	protected final void addDateMin(String fieldName, String value) {
		addDate(fieldName, value, GREATER_EQUAL);
	}

	protected final void addDateMax(String fieldName, String value) {
		addDate(fieldName, value, LESS_EQUAL);
	}

	protected final void addString(String fieldName, Object value,
			Object operator) {
		if (StringUtils.isEmpty(fieldName))
			return;
		if (!isAvailableValue(value))
			return;
		translater.addString(fieldName, value, operator);
	}

	protected final void addString(String fieldName, String value) {
		if (StringUtils.isEmpty(fieldName))
			return;
		if (!isAvailableValue(value))
			return;
		if (value.indexOf("*") > -1)
			translater.addString(fieldName, value, LIKE);
		else
			translater.addString(fieldName, value, EQUAL);
	}

	protected final void addAscendingOrderByColumn(String fieldName) {
		if (StringUtils.isEmpty(fieldName))
			return;
		translater.addAscendingOrderByColumn(fieldName);
	}

	protected final void addDescendingOrderByColumn(String fieldName) {
		if (StringUtils.isEmpty(fieldName))
			return;
		translater.addDescendingOrderByColumn(fieldName);
	}

	/**
	 * @return
	 */
	public DateFormat getDateFormat() {
		return dateFormat;
	}

	/**
	 * @param format
	 */
	public void setDateFormat(DateFormat format) {
		dateFormat = format;
	}

	public static final String EQUAL = "=";

	public static final String GREATER_EQUAL = ">=";

	public static final String GREATER = ">";

	public static final String LESS_EQUAL = "<=";

	public static final String LESS = "<";

	public static final String LIKE = "like";

	public static final String IN = "in";

	public static final String NOT_IN = "not in";

	/**
	 * @return
	 */
	public ConditionTranslator getTranslater() {
		return translater;
	}

}