/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/05
 */
package org.asyrinx.joey.tapestry.components.stative;

import java.util.HashMap;
import java.util.Map;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.html.Body;
import org.asyrinx.brownie.tapestry.script.ScriptUtils;
import org.asyrinx.brownie.tapestry.util.ComponentUtils;

/**
 * @author akima
 */
public class FormEditingControl extends AbstractFormComponent {

	/**
	 * @see org.apache.tapestry.AbstractComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
	 *        org.apache.tapestry.IRequestCycle)
	 */
	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		this.form = getForm(cycle);
		final IPage page = getPage();
		if (page instanceof BaseEditPage) {
			final BaseEditPage editPage = (BaseEditPage) page;
			if (!editPage.isEditing()) {
				final Body body = getBodyComponent(page);
				final IScript loadedScript = loadScript(this);
				addScript(cycle, loadedScript, body);
			}
		}
	}

	protected Body getBodyComponent(IPage page) {
		final IComponent component = ComponentUtils.searchBottomByClass(page,
				Body.class);
		if (component instanceof Body)
			return (Body) component;
		else
			throw new ApplicationRuntimeException("must-have-Body-component",
					this, null, null);
	}

	public static final String SYM_TARGET_FORM_NAME = "targetFormName";

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#addScript(org.apache.tapestry.IRequestCycle,
	 *        org.apache.tapestry.IScript, org.apache.tapestry.html.Body)
	 */
	protected void addScript(IRequestCycle cycle, IScript targetScript,
			Body body) {
		final Map symbols = new HashMap();
		symbols.put(SYM_TARGET_FORM_NAME, form.getName());
		targetScript.execute(cycle, body, symbols);
	}

	private static final String SCRIPT_NAME = "FormEditingControl.script";

	private IScript script = null;

	/**
	 * @return
	 */
	protected IScript loadScript(IComponent component) {
		if (script == null)
			script = ScriptUtils.loadScript(component, SCRIPT_NAME);
		return script;
	}

	private String name = null;

	/**
	 * @see org.apache.tapestry.form.IFormComponent#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * @see org.apache.tapestry.form.IFormComponent#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @see org.apache.tapestry.form.AbstractFormComponent#isDisabled()
	 */
	public boolean isDisabled() {
		return false;
	}

	private IForm form = null;

	/**
	 * @see org.apache.tapestry.form.IFormComponent#getForm()
	 */
	public IForm getForm() {
		return form;
	}

	/**
	 * @see org.apache.tapestry.form.AbstractFormComponent#setForm(org.apache.tapestry.IForm)
	 */
	public void setForm(IForm form) {
		this.form = form;
	}

}