/*
 * joey-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/28 1:28:16
 */
package org.asyrinx.joey.test.dao;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.util.ResourceUtil;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public abstract class S2TestCaseBase extends TestCase {

    /**
     *  
     */
    public S2TestCaseBase(String name) {
        super(name);
    }

    protected S2Container container_;

    public S2Container getContainer() {
        return container_;
    }

    public Object getComponent(String componentName) {
        return container_.getComponent(componentName);
    }

    public Object getComponent(Class componentClass) {
        return container_.getComponent(componentClass);
    }

    public ComponentDef getComponentDef(String componentName) {
        return container_.getComponentDef(componentName);
    }

    public ComponentDef getComponentDef(Class componentClass) {
        return container_.getComponentDef(componentClass);
    }

    public void register(Class componentClass) {
        container_.register(componentClass);
    }

    public void register(Class componentClass, String componentName) {
        container_.register(componentClass, componentName);
    }

    public void register(Object component) {
        container_.register(component);
    }

    public void register(Object component, String componentName) {
        container_.register(component, componentName);
    }

    public void register(ComponentDef componentDef) {
        container_.register(componentDef);
    }

    public void include(String path) {
        container_.include(S2ContainerFactory.create(convertPath(path)));
    }

    private String convertPath(String path) {
        if (ResourceUtil.getResourceNoException(path) != null)
            return path;
        final String prefix = getClass().getPackage().getName().replace('.', '/');
        return prefix + "/" + path;
    }

    /*
     * (non-Javadoc)
     * 
     * @see junit.framework.TestCase#runBare()
     */
    public void runBare() throws Throwable {
        container_ = new S2ContainerImpl();
        setUpContainer();
        container_.init();
        try {
            afterSetupContainer();
            executeRunBare();
        } finally {
            container_.destroy();
        }
    }

    /**
     * @throws Throwable
     *  
     */
    protected void afterSetupContainer() throws Throwable {
        //do nothing
    }

    /**
     * @throws Throwable
     *  
     */
    protected void executeRunBare() throws Throwable {
        super.runBare();
    }

    /**
     * include\bhĂяotemplate\bh
     */
    protected abstract void setUpContainer();

}