/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 17:39:41
 */
package org.asyrinx.brownie.core.chars.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections.iterators.ArrayIterator;
import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

/**
 * @author takeshi
 */
public abstract class AbstractCompositeCharacters implements Characters {

    /**
     *  
     */
    public AbstractCompositeCharacters(String name) {
        super();
        this.name = name;
    }

    /**
     *  
     */
    public AbstractCompositeCharacters(String name, Object components) {
        this(StringUtils.isEmpty(name) ? buildName(toIterator(components)) : name);
    }

    private final String name;

    public String getName() {
        return name;
    }

    public static String buildName(Iterator componentsIterator) {
        final StringBuffer result = new StringBuffer();
        for (Iterator i = componentsIterator; i.hasNext();) {
            final Characters characterSet = (Characters) i.next();
            result.append(characterSet.getName());
            if (i.hasNext())
                result.append(",");
        }
        return result.toString();
    }

    protected static Iterator toIterator(Object components) {
        if (components.getClass().isArray()) {
            return new ArrayIterator(components);
        } else if (components instanceof Collection) {
            return ((Collection) components).iterator();
        } else {
            throw new UnsupportedClassRuntimeException("components must be array or Collection");
        }
    }

    protected static Iterator toIterator(List components) {
        return components.iterator();
    }

    protected abstract Iterator componentIterator();

    public boolean contains(char c) {
        for (Iterator i = componentIterator(); i.hasNext();) {
            final Characters characters = (Characters) i.next();
            if (characters.contains(c))
                return true;
        }
        return false;
    }

    public String expandToString() {
        final StringBuffer result = new StringBuffer();
        for (Iterator i = componentIterator(); i.hasNext();) {
            final Characters characters = (Characters) i.next();
            result.append(characters.expandToString());
        }
        return result.toString();
    }
}