/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 2:03:43
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Map;
import java.util.Properties;

import org.asyrinx.brownie.core.collection.MapFactory;

/**
 * @author akima
 */
public class DefaultMapTree extends ArrayKeyBasedMapTreeAdapter implements MapTree.PropertiesAccessible {

    /**
     *  
     */
    public DefaultMapTree() {
        this(null);
    }

    /**
     *  
     */
    public DefaultMapTree(Map root) {
        this(root, null);
    }

    /**
     *  
     */
    public DefaultMapTree(Map root, MapFactory mapFactory) {
        super(new ArrayKeyHashMapTree(root, mapFactory), new DefaultMapTreeKeyFactory());
        this.accessor = (keyFactory instanceof MapTree.PropertiesAccessibleSupport) ? (MapTree.PropertiesAccessibleSupport) keyFactory
                : null;
    }

    private final MapTree.PropertiesAccessibleSupport accessor;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.PropertiesAccessibleMapTree#loadFrom(java.util.Properties)
     */
    public void loadFrom(Properties source) {
        accessor.loadFromProperties(this, source);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.collection.maptree.PropertiesAccessibleMapTree#saveTo(java.util.Properties)
     */
    public void saveTo(Properties dest) {
        accessor.saveToProperties(this, dest);
    }

}