/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package org.asyrinx.brownie.core.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * ΃pXA΃pXȂǂɌ炸pXwʒu\NXłB
 * 
 * @author akima
 * @see org.asyrinx.brownie.core.io.FileNameUtils
 */
public class PathPointer {

	/**
	 *  
	 */
	public PathPointer() {
		super();
	}

	/**
	 *  
	 */
	public PathPointer(String path) {
		super();
		setPath(path);
	}

	/**
	 *  
	 */
	public PathPointer(File file) {
		this(file.getPath());
	}

	private final List dirList = new ArrayList();

	private String separator = FileConstants.FILE_SPARATOR_SLASH;

	/**
	 * @return
	 */
	public String getPath() {
		return StringUtils.join(this.dirList.iterator(), this.separator);
	}

	/**
	 * @param string
	 */
	public void setPath(String path) {
		dirList.clear();
		path = FileNameUtils.deleteSeparatorTail(path);
		this.separator = FileNameUtils.getFileSeparator(path);
		StringUtils.tokenize(dirList, path, this.separator);
	}

	public File toFile() {
		return new File(getPath());
	}

	public void moveTo(String relativePath) {
		changeImpl(relativePath);
	}

	public void goUp() {
		changeImpl(FileConstants.DIRECTORY_PARENT);
	}

	public void goDown(String directoryName) {
		changeImpl(directoryName);
	}

	protected void changeImpl(String relativePath) {
		final String path = FileNameUtils.toFileSeparatorSlash(FileNameUtils
				.deleteSeparatorHead(relativePath));
		final List pathList = StringUtils.tokenize(path,
				FileConstants.FILE_SPARATOR_SLASH);
		final Iterator iterator = pathList.iterator();
		while (iterator.hasNext()) {
			final String dir = (String) iterator.next();
			if (dir.equals(FileConstants.DIRECTORY_CURRENT))
				continue;
			if (dir.equals(FileConstants.DIRECTORY_PARENT))
				this.dirList.remove(this.dirList.size() - 1);
			else
				this.dirList.add(dir);
		}
	}

}