/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * @author Akima
 */
public class ZipEntryFileStreamFactory extends AbstractFileStreamFactory {

    /**
     * Constructor for ZipEntryFileStreamFactory.
     */
    public ZipEntryFileStreamFactory(String zipFilePath) {
        this(new File(zipFilePath));
    }

    /**
     * Constructor for ZipEntryFileStreamFactory.
     */
    public ZipEntryFileStreamFactory(File zipFile) {
        super();
        this.zipFile = zipFile;
    }

    private final File zipFile;

    private ZipFile targetZip = null;

    protected void initZipFile() throws IOException {
        if (targetZip != null)
            return;
        targetZip = new ZipFile(this.zipFile);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newInput(java.lang.Object)
     */
    public InputStream newInput(Object key) throws IOException {
        initZipFile();
        final String path = keyToString(key);
        final ZipEntry entry = new ZipEntry(path);
        final InputStream result = targetZip.getInputStream(entry);
        if (result == null)
            throw new IOException("Xg[[" + key + "]̎擾Ɏs܂B");
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newOutput(java.lang.Object)
     */
    public OutputStream newOutput(Object key) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory#keyFileToString(java.io.File)
     */
    protected String keyFileToString(File key) {
        return key.getPath();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.DirectoryBaseFileStreamFactory#getCaption()
     */
    public String getCaption() {
        return this.zipFile.getAbsolutePath();
    }

}