/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/20 23:18:51
 */
package org.asyrinx.brownie.core.query.exp;

import org.asyrinx.brownie.core.query.model.FieldAlias;

/**
 * @author takeshi
 */
public class FieldCompare implements IFieldCompare {

    /**
     *  
     */
    public FieldCompare() {
        super();
    }

    public FieldCompare(FieldAlias left, FieldAlias right) {
        this(left, right, IExpression.EQUAL);
    }

    public FieldCompare(FieldAlias left, FieldAlias right, String operator) {
        super();
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    private String operator = null;

    private FieldAlias left = null;

    private FieldAlias right = null;

    /**
     * @return Returns the left.
     */
    public FieldAlias getLeft() {
        return left;
    }

    /**
     * @param left
     *            The left to set.
     */
    public void setLeft(FieldAlias left) {
        this.left = left;
    }

    /**
     * @return Returns the operator.
     */
    public String getOperator() {
        return operator;
    }

    /**
     * @param operator
     *            The operator to set.
     */
    public void setOperator(String operator) {
        this.operator = operator;
    }

    /**
     * @return Returns the right.
     */
    public FieldAlias getRight() {
        return right;
    }

    /**
     * @param right
     *            The right to set.
     */
    public void setRight(FieldAlias right) {
        this.right = right;
    }
}