/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/19 23:58:36
 */
package org.asyrinx.brownie.core.query.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author takeshi
 */
public class Table {

    /**
     * @param rdbName
     * @param javaName
     */
    public Table(String rdbName, String javaName) {
        super();
        this.rdbName = rdbName;
        this.javaName = javaName;
    }

    private String rdbName;

    /**
     * @return Returns the rdbName.
     */
    public String getRdbName() {
        return rdbName;
    }

    /**
     * @param rdbName
     *            The rdbName to set.
     */
    public void setRdbName(String name) {
        this.rdbName = name;
    }

    private String javaName;

    /**
     * @return Returns the javaName.
     */
    public String getJavaName() {
        return javaName;
    }

    /**
     * @param javaName
     *            The javaName to set.
     */
    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    private final List fields = new ArrayList();

    /**
     * @param field
     * @return
     */
    public Table add(Field field) {
        if (field == null)
            return null;
        if (this.contains(field))
            return this;
        fields.add(field);
        if (field.getTable() != this)
            field.setParent(this);
        return this;
    }

    public Table addField(Class type, String rdbName) {
        return this.addField(type, rdbName, null);
    }

    public Table addField(Class type, String rdbName, String format) {
        return this.add(new Field(this, type, rdbName, format));
    }

    /**
     *  
     */
    public void clear() {
        fields.clear();
    }

    /**
     * @param field
     * @return
     */
    public boolean contains(Field field) {
        return fields.contains(field);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        return fields.equals(obj);
    }

    /**
     * @param index
     * @return
     */
    public Field get(int index) {
        return (Field) fields.get(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.ITable#getField(java.lang.String)
     */
    public Field getField(String fieldName) {
        final int index = this.indexOfRdbName(fieldName);
        if (index < 0) {
            return null;
        }
        return get(index);
    }

    /**
     * @param field
     * @return
     */
    public int indexOf(Field field) {
        return fields.indexOf(field);
    }

    /**
     * @param rdbName
     * @return
     */
    public int indexOfRdbName(String rdbName) {
        if (StringUtils.isEmpty(rdbName))
            return -1;
        for (int i = 0; i < fields.size(); i++) {
            final Field field = (Field) fields.get(i);
            if (rdbName.equals(field.getRdbName())) {
                return i;
            }
        }
        return -1;
    }

    /**
     * @param rdbName
     * @return
     */
    public int indexOfJavaName(String javaName) {
        if (StringUtils.isEmpty(javaName))
            return -1;
        for (int i = 0; i < fields.size(); i++) {
            final Field field = (Field) fields.get(i);
            if (javaName.equals(field.getJavaName())) {
                return i;
            }
        }
        return -1;
    }

    /**
     * @return
     */
    public boolean isEmpty() {
        return fields.isEmpty();
    }

    /**
     * @return
     */
    public Iterator iterator() {
        return fields.iterator();
    }

    /**
     * @param field
     * @return
     */
    public boolean remove(Field field) {
        return fields.remove(field);
    }

    /**
     * @return
     */
    public int size() {
        return fields.size();
    }

    /**
     * @return
     */
    public Field[] toArray() {
        return (Field[]) fields.toArray();
    }

    private final Map aliasMap = new HashMap();

    public TableAlias findAlias(String name) {
        return (TableAlias) aliasMap.get(name);
    }

    public TableAlias alias() {
        return alias(this.getRdbName());
    }

    public TableAlias alias(String aliasName) {
        final TableAlias alias = findAlias(aliasName);
        if (alias != null) {
            return alias;
        } else {
            final TableAlias resutl = new TableAlias(this, aliasName);
            aliasMap.put(aliasName, resutl);
            return resutl;
        }
    }

}