/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 14:08:11
 */
package org.asyrinx.brownie.core.resource;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.MissingResourceException;

import org.apache.commons.lang.exception.Nestable;
import org.apache.commons.lang.exception.NestableDelegate;

/**
 * @author takeshi
 */
public class MessageResourceRuntimeException extends MissingResourceException implements Nestable {

    /**
     * @param s
     * @param className
     * @param key
     */
    public MessageResourceRuntimeException(String s, String className, String key) {
        this(s, className, key, null);
    }

    /**
     * @param s
     * @param className
     * @param key
     */
    public MessageResourceRuntimeException(String s, String className, String key, Throwable cause) {
        super(s, className, key);
        this.cause = cause;
    }

    protected NestableDelegate delegate = new NestableDelegate(this);

    protected final Throwable cause;

    public Throwable getCause() {
        return cause;
    }

    /**
     * Returns the detail message string of this throwable. If it was created
     * with a null message, returns the following: (cause==null ? null :
     * cause.toString()).
     */
    public String getMessage() {
        if (super.getMessage() != null) {
            return super.getMessage();
        } else if (cause != null) {
            return cause.toString();
        } else {
            return null;
        }
    }

    public String getMessage(int index) {
        if (index == 0) {
            return super.getMessage();
        } else {
            return delegate.getMessage(index);
        }
    }

    public String[] getMessages() {
        return delegate.getMessages();
    }

    public Throwable getThrowable(int index) {
        return delegate.getThrowable(index);
    }

    public int getThrowableCount() {
        return delegate.getThrowableCount();
    }

    public Throwable[] getThrowables() {
        return delegate.getThrowables();
    }

    public int indexOfThrowable(Class type) {
        return delegate.indexOfThrowable(type, 0);
    }

    public int indexOfThrowable(Class type, int fromIndex) {
        return delegate.indexOfThrowable(type, fromIndex);
    }

    public void printStackTrace() {
        delegate.printStackTrace();
    }

    public void printStackTrace(PrintStream out) {
        delegate.printStackTrace(out);
    }

    public void printStackTrace(PrintWriter out) {
        delegate.printStackTrace(out);
    }

    public final void printPartialStackTrace(PrintWriter out) {
        super.printStackTrace(out);
    }
}