/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 14:38:27
 */
package org.asyrinx.brownie.core.resource.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.MessageResourceRuntimeException;

/**
 * @author takeshi
 */
public class CompositeMessageResource implements MessageResource {

    /**
     *  
     */
    public CompositeMessageResource() {
        super();
    }

    public String getMessage(String key) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final MessageResource resource = (MessageResource) i.next();
            try {
                final String result = resource.getMessage(key);
                if (result != null)
                    return result;
            } catch (Throwable e) {
                //MessageResource
            }
        }
        throw new MessageResourceRuntimeException("message not found.", getBase(), key);
    }

    public String getBase() {
        final StringBuffer result = new StringBuffer();
        for (Iterator i = this.iterator(); i.hasNext();) {
            final MessageResource resource = (MessageResource) i.next();
            result.append(resource.getBase());
        }
        return result.toString();
    }

    private final List resources = new ArrayList();

    public boolean add(MessageResource resource) {
        return resources.add(resource);
    }

    public void clear() {
        resources.clear();
    }

    public boolean contains(MessageResource resource) {
        return resources.contains(resource);
    }

    public MessageResource get(int index) {
        return (MessageResource) resources.get(index);
    }

    public int indexOf(MessageResource resource) {
        return resources.indexOf(resource);
    }

    public boolean isEmpty() {
        return resources.isEmpty();
    }

    public Iterator iterator() {
        return resources.iterator();
    }

    public boolean remove(MessageResource resource) {
        return resources.remove(resource);
    }

    public int size() {
        return resources.size();
    }
}