/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 17:53:12
 */
package org.asyrinx.brownie.core.text;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * @author takeshi
 */
public class EscapedStringSplitter {

    /**
     * @param string
     */
    public EscapedStringSplitter(char delimiter) {
        this(delimiter, '\\');
    }

    /**
     * @param string
     */
    public EscapedStringSplitter(char delimiter, char escapeSymbol) {
        this.delimiter = delimiter;
        this.escapeSymbol = escapeSymbol;
    }

    private final char delimiter;

    private final char escapeSymbol;

    /**
     * @param string
     * @param dest
     * @return
     */
    public void execute(String value, List dest) {
        if (value == null)
            return;
        if (StringUtils.isEmpty(value)) {
            dest.add("");
            return;
        }
        int idxLast = -1;
        int idxCurr = value.indexOf(delimiter, idxLast + 1);
        int idxEscaped = -1;
        while (idxCurr > -1) {
            if (isAfterEscapeSymbol(value, idxCurr)) {
                idxEscaped = idxCurr;
                idxCurr = value.indexOf(delimiter, idxEscaped + 1);
                continue;
            }
            final String parsed = buildParsed(value, idxLast, idxCurr, idxEscaped);
            dest.add(parsed);
            idxLast = idxCurr;
            idxCurr = value.indexOf(delimiter, idxLast + 1);
            idxEscaped = -1;
        }
        final String parsed = buildParsed(value, idxLast, value.length(), idxEscaped);
        dest.add(parsed);
    }

    private boolean isAfterEscapeSymbol(String value, int index) {
        if (index < 1)
            return false;
        return value.charAt(index - 1) == escapeSymbol;
    }

    /**
     * @param value
     * @param idxLast
     * @param idxCurr
     * @param idxEscaped
     * @return
     */
    private String buildParsed(String value, int idxLast, int idxCurr, int idxEscaped) {
        if (idxEscaped < 0)
            return value.substring(idxLast + 1, idxCurr);
        else
            return value.substring(idxLast + 1, idxEscaped - 1)
                    + value.substring(idxEscaped, idxCurr);
    }

    /**
     * @param string
     * @return
     */
    public String[] execute(String value) {
        final List result = new ArrayList();
        execute(value, result);
        return (String[]) result.toArray(new String[0]);
    }

    public char getEscapeSymbol() {
        return escapeSymbol;
    }

}