/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 4:14:55
 */
package org.asyrinx.brownie.core.util;

import java.util.Comparator;

/**
 * @author akima
 */
public class ComparatorUtils {

    public static Comparator inverse(Comparator comparator) {
        return new InversedComparator(comparator);
    }

}

class InversedComparator implements Comparator {
    InversedComparator(Comparator wrapped) {
        this.wrapped = wrapped;
    }

    final Comparator wrapped;

    public int compare(Object o1, Object o2) {
        return -1 * compare(o1, o2);
    }
}