/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author akima
 */
public final class DateUtils {

    private static final Date INFINITE_PAST = new Date() {
        public long getTime() {
            return Long.MIN_VALUE;
        }

        public void setTime(long time) {
            throw new UnsupportedOperationException("cannot set time" + DateUtils.class.getName() + ".INFINITE_PAST");
        }
    };

    private static final Date INFINITE_FUTURE = new Date() {
        public long getTime() {
            return Long.MAX_VALUE;
        }

        public void setTime(long time) {
            throw new UnsupportedOperationException("cannot set time to " + DateUtils.class.getName()
                    + ".INFINITE_FUTURE");
        }
    };

    public static Date getInfinitePast() {
        return INFINITE_PAST;
    }

    public static Date getInfiniteFuture() {
        return INFINITE_FUTURE;
    }

    public static boolean isInfinitePast(Date date) {
        return (date != null) ? (date.getTime() == Long.MIN_VALUE) : false;
    }

    public static boolean isInfiniteFuture(Date date) {
        return (date != null) ? (date.getTime() == Long.MAX_VALUE) : false;
    }

    public static Date toDateTime(int year, int month, int day, int hours, int minuites, int seconds, int milliseconds) {
        final Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hours, minuites, seconds);
        cal.set(Calendar.MILLISECOND, milliseconds);
        return new Date(cal.getTime().getTime());
    }

    public static Date adjustDateTime(Date d, int hours, int minuites, int seconds, int miliseconds) {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return toDateTime(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH), cal.get(Calendar.DAY_OF_MONTH), hours,
                minuites, seconds, miliseconds);
    }

    public static Date adjustDateBegin(Date d) {
        return adjustDateTime(d, 0, 0, 0, 0);
    }

    public static Date adjustDateEnd(Date d) {
        return adjustDateTime(d, 23, 59, 59, 999);
    }

    public static int get(Date d, int calendarField) {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(calendarField);
    }

    public static int getYear(Date d) {
        return get(d, Calendar.YEAR);
    }

    public static int getMonth(Date d) {
        return get(d, Calendar.MONTH);
    }

    public static int getDay(Date d) {
        return get(d, Calendar.DAY_OF_MONTH);
    }

    /**
     * w肳ꂽNDateIuWFNg𐶐܂B <br>
     * 1IWłB <br>
     * 
     * @param year
     *            N
     * @param month
     *            (1-12)
     * @param day
     *            
     * @return
     */
    public static Date toDate(int year, int month, int day) {
        return toDate(year, month, day, 0, 0);
    }

    /**
     * w肳ꂽNDateIuWFNg𐶐܂B <br>
     * 1IWłB <br>
     * 
     * @param year
     *            N
     * @param month
     *            (1-12)
     * @param day
     *            
     * @param hours
     *            (0-23)
     * @param minutes
     *            (0-59)
     * @return
     */
    public static Date toDate(int year, int month, int day, int hours, int minutes) {
        return toDate(year, month, day, hours, minutes, 0);
    }

    /**
     * w肳ꂽNbDateIuWFNg𐶐܂B <br>
     * 1IWłB <br>
     * 
     * @param year
     *            N
     * @param month
     *            (1-12)
     * @param day
     *            
     * @param hours
     *            (0-23)
     * @param minutes
     *            (0-59)
     * @param seconds
     *            b(0-59)
     * @return
     */
    public static Date toDate(int year, int month, int day, int hours, int minutes, int seconds) {
        return toDate(year, month, day, hours, minutes, seconds, 0);
    }

    /**
     * w肳ꂽNb~bDateIuWFNg𐶐܂B <br>
     * 1IWłB <br>
     * 
     * @param year
     *            N
     * @param month
     *            (1-12)
     * @param day
     *            
     * @param hours
     *            (0-23)
     * @param minutes
     *            (0-59)
     * @param seconds
     *            b(0-59)
     * @param milliseconds
     *            ~b(0-999)
     * @return
     */
    public static Date toDate(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        final Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hours, minutes, seconds);
        cal.set(Calendar.MILLISECOND, milliseconds);
        return new Date(cal.getTime().getTime());
    }

    /**
     * w肳ꂽt000b0~bɐݒ肳ꂽDateIuWFNgԂ
     * 
     * @param y
     * @param m
     * @param d
     * @return
     */
    public static Date toDateBegin(int y, int m, int d) {
        return toDateTime(y, m, d, 0, 0, 0, 0);
    }

    /**
     * w肳ꂽt235959b999~bɐݒ肳ꂽDateIuWFNgԂ
     * 
     * @param y
     * @param m
     * @param d
     * @return
     */
    public static Date toDateEnd(int y, int m, int d) {
        return toDateTime(y, m, d, 23, 59, 59, 999);
    }

    /**
     * 邤Nǂ𔻒f܂B
     * 
     * @param year
     * @return
     */
    public static boolean isLeapYear(int year) {
        final GregorianCalendar calendar = new GregorianCalendar();
        return calendar.isLeapYear(year);
    }

    /**
     * w肳ꂽ̍ŏ̓tDate^ŕԂ܂B
     * 
     * @param year
     *            N
     * @param month
     *             1IWł
     * @return
     */
    public static Date getBeginDateOfMonth(int year, int month) {
        final Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return new Date(calendar.getTimeInMillis());
    }

    /**
     * w肳ꂽ̍Ō̓tDate^ŕԂ܂B
     * 
     * @param year
     *            N
     * @param month
     *             1IWł
     * @return
     */
    public static Date getLastDateOfMonth(int year, int month) {
        final Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DAY_OF_MONTH, getLastDayOfMonth(year, month));
        return new Date(calendar.getTimeInMillis());
    }

    /**
     * w肳ꂽ̍Ō̓intŕԂ܂B
     * 
     * @param year
     *            N
     * @param month
     *             1IWł
     * @return
     */
    public static int getLastDayOfMonth(int year, int month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DAY_OF_MONTH, 1); //ꂪȂƃ_łB
        return calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
    }

}