/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 11:11:07
 */
package org.asyrinx.brownie.core.xml.digester;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

/**
 * @author takeshi
 */
public class RuleWrapper extends Rule {

    /**
     *  
     */
    public RuleWrapper(Rule wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final Rule wrapped;

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        wrapped.begin(namespace, name, attributes);
    }

    /**
     * @deprecated
     */
    public void begin(Attributes attributes) throws Exception {
        wrapped.begin(attributes);
    }

    /**
     * @deprecated
     */
    public void body(String text) throws Exception {
        wrapped.body(text);
    }

    public void body(String namespace, String name, String text) throws Exception {
        wrapped.body(namespace, name, text);
    }

    /**
     * @deprecated
     */
    public void end() throws Exception {
        wrapped.end();
    }

    public void end(String namespace, String name) throws Exception {
        wrapped.end(namespace, name);
    }

    public void finish() throws Exception {
        wrapped.finish();
    }

    public Digester getDigester() {
        return wrapped.getDigester();
    }

    public String getNamespaceURI() {
        return wrapped.getNamespaceURI();
    }

    public void setDigester(Digester digester) {
        wrapped.setDigester(digester);
    }

    public void setNamespaceURI(String namespaceURI) {
        wrapped.setNamespaceURI(namespaceURI);
    }
}