/*
 * Created on 2004/11/15
 */
package org.asyrinx.brownie.core.xml.dom.impl;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.core.util.jp.JpDateFormat;
import org.asyrinx.brownie.core.xml.dom.DomBuilder;
import org.asyrinx.brownie.core.xml.dom.RenderingAttribute;
import org.asyrinx.brownie.core.xml.dom.RenderingDuplicated;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author takeshi
 */
public abstract class AbstractDomBuilder implements DomBuilder {

    /**
     *  
     */
    public AbstractDomBuilder() {
        this(null, null);
    }

    /**
     * @param renderingDuplicated
     * @param renderingAttribute
     */
    public AbstractDomBuilder(RenderingDuplicated renderingDuplicated, RenderingAttribute renderingAttribute) {
        super();
        this.renderingDuplicated = (renderingDuplicated != null) ? renderingDuplicated : RenderingDuplicated.TAKE_FIRST;
        this.renderingAttribute = (renderingAttribute != null) ? renderingAttribute : RenderingAttribute.NULL;
    }

    private DateFormat dateFormat = new JpDateFormat("yyyy/MM/dd HH:mm:ss");

    protected Document document = null;

    private RenderingDuplicated renderingDuplicated;

    private RenderingAttribute renderingAttribute;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.xml.dom.DomBuilder#prepareRoot(org.w3c.dom.Element,
     *      java.lang.Object)
     */
    public void prepareRoot(Element root, Object bean) {
        getRenderingDuplicated().clear();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.co.tecowl.spike.fop2.DomBuilder#execute(org.w3c.dom.Document,
     *      java.lang.Object, org.w3c.dom.Element)
     */
    public void execute(Document document, Object bean, Element element) {
        this.document = document;
        this.execute(bean, element);
    }

    protected void execute(Object bean, Element element) {
        final Map properties;
        try {
            properties = PropertyUtils.describe(bean);
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Iterator i = properties.keySet().iterator(); i.hasNext();) {
            final Object key = i.next();
            if (key == null)
                continue;
            if ("class".equals(key))
                continue;
            final Object value = properties.get(key);
            if (value == null)
                continue;
            renderToElement(element, key, value);
        }
    }

    /**
     * @param element
     * @param key
     * @param value
     */
    abstract protected void renderToElement(Element element, Object key, Object value);

    protected String toString(Object key, Object value) {
        return toString(value);
    }

    protected String toString(Object value) {
        if (value instanceof Date)
            return dateFormat.format((Date) value);
        else if (value instanceof Class)
            return ((Class) value).getName();
        else
            return String.valueOf(value);
    }

    public RenderingDuplicated getRenderingDuplicated() {
        return renderingDuplicated;
    }

    public void setRenderingDuplicated(RenderingDuplicated renderingDuplicated) {
        this.renderingDuplicated = renderingDuplicated;
    }

    public RenderingAttribute getRenderingAttribute() {
        return renderingAttribute;
    }

    public void setRenderingAttribute(RenderingAttribute renderingAttribute) {
        this.renderingAttribute = renderingAttribute;
    }

    public DateFormat getDateFormat() {
        return dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }
}