/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Transaction;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.wrapper.TransactionWrapper;

/**
 * @author akima
 */
public class LogTransaction extends TransactionWrapper {

	/**
	 * @param wrapped
	 * @param log
	 */
	public LogTransaction(Transaction wrapped, CascadeNamedLog parentLog) {
		super(wrapped);
		this.log = parentLog.subLog(wrapped);
	}

	protected final CascadeNamedLog log;

	/**
	 * @see net.sf.hibernate.Transaction#commit()
	 */
	public void commit() throws HibernateException {
		super.commit();
		log.log("commit()");
	}

	/**
	 * @see net.sf.hibernate.Transaction#rollback()
	 */
	public void rollback() throws HibernateException {
		super.rollback();
		log.log("rollback()");
	}

}