/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;

import javax.naming.NamingException;
import javax.naming.Reference;

import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;

/**
 * @author akima
 */
public class SessionFactoryWrapper implements SessionFactory {

	/**
	 *  
	 */
	public SessionFactoryWrapper() {
		super();
	}

	protected SessionFactory source;

	/**
	 * @return
	 */
	public SessionFactory getSource() {
		return source;
	}

	/**
	 * @param factory
	 */
	public void setSource(SessionFactory factory) {
		source = factory;
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void close() throws HibernateException {
		source.close();
	}

	/**
	 * @param persistentClass
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evict(Class persistentClass) throws HibernateException {
		source.evict(persistentClass);
	}

	/**
	 * @param persistentClass
	 * @param id
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evict(Class persistentClass, Serializable id)
			throws HibernateException {
		source.evict(persistentClass, id);
	}

	/**
	 * @param roleName
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evictCollection(String roleName) throws HibernateException {
		source.evictCollection(roleName);
	}

	/**
	 * @param roleName
	 * @param id
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evictCollection(String roleName, Serializable id)
			throws HibernateException {
		source.evictCollection(roleName, id);
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evictQueries() throws HibernateException {
		source.evictQueries();
	}

	/**
	 * @param cacheRegion
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evictQueries(String cacheRegion) throws HibernateException {
		source.evictQueries(cacheRegion);
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Map getAllClassMetadata() throws HibernateException {
		return source.getAllClassMetadata();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Map getAllCollectionMetadata() throws HibernateException {
		return source.getAllCollectionMetadata();
	}

	/**
	 * @param persistentClass
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public ClassMetadata getClassMetadata(Class persistentClass)
			throws HibernateException {
		return source.getClassMetadata(persistentClass);
	}

	/**
	 * @param roleName
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public CollectionMetadata getCollectionMetadata(String roleName)
			throws HibernateException {
		return source.getCollectionMetadata(roleName);
	}

	/**
	 * @return @throws
	 *         javax.naming.NamingException
	 */
	public Reference getReference() throws NamingException {
		return source.getReference();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Databinder openDatabinder() throws HibernateException {
		return source.openDatabinder();
	}

	/**
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Session openSession() throws HibernateException {
		return source.openSession();
	}

	/**
	 * @param connection
	 * @return
	 */
	public Session openSession(Connection connection) {
		return source.openSession(connection);
	}

	/**
	 * @param connection
	 * @param interceptor
	 * @return
	 */
	public Session openSession(Connection connection, Interceptor interceptor) {
		return source.openSession(connection, interceptor);
	}

	/**
	 * @param interceptor
	 * @return @throws
	 *         net.sf.hibernate.HibernateException
	 */
	public Session openSession(Interceptor interceptor)
			throws HibernateException {
		return source.openSession(interceptor);
	}

}