/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 19:31:30
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

/**
 * @author takeshi
 */
public class XAConnectionWrapper implements XAConnection {

    /**
     *  
     */
    public XAConnectionWrapper(XAConnection wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final XAConnection wrapped;

    public void addConnectionEventListener(ConnectionEventListener listener) {
        wrapped.addConnectionEventListener(listener);
    }

    public void close() throws SQLException {
        wrapped.close();
    }

    public Connection getConnection() throws SQLException {
        return wrapped.getConnection();
    }

    public XAResource getXAResource() throws SQLException {
        return wrapped.getXAResource();
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        wrapped.removeConnectionEventListener(listener);
    }
}