/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/28 15:03:44
 */
package org.asyrinx.brownie.seasar.dbcp.logger;

import java.sql.SQLException;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.seasar.dbcp.wrapper.ConnectionPoolWrapper;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;

/**
 * @author takeshi
 */
public class LogConnectionPool extends ConnectionPoolWrapper {

    /**
     * @param wrapped
     */
    public LogConnectionPool(ConnectionPool wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     */
    public LogConnectionPool(ConnectionPool wrapped, String name) {
        this(wrapped, new CascadeNamedLog(name, DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     */
    public LogConnectionPool(ConnectionPool wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    protected final CascadeNamedLog log;

    public void checkIn(ConnectionWrapper connectionWrapper) {
        try {
            super.checkIn(connectionWrapper);
            log.log("checkIn(" + connectionWrapper + ")");
        } catch (RuntimeException e) {
            log.error("failed to checkIn(" + connectionWrapper + ")", e);
            throw e;
        }
    }

    public ConnectionWrapper checkOut() throws SQLException {
        try {
            final ConnectionWrapper result = super.checkOut();
            log.log("checkOut(): " + result);
            return new LogConnectionWrapper(result, log.subLog(result));
        } catch (SQLException e) {
            log.error("failed to checkIn()", e);
            throw e;
        }
    }

    public void close() {
        try {
            super.close();
            log.log("close()");
        } catch (RuntimeException e) {
            log.error("failed to close()", e);
            throw e;
        }
    }

    public void release(ConnectionWrapper connectionWrapper) {
        try {
            super.release(connectionWrapper);
            log.log("release(" + connectionWrapper + ")");
        } catch (RuntimeException e) {
            log.error("release(" + connectionWrapper + ")", e);
            throw e;
        }
    }
}