/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/15 14:38:38
 */
package org.asyrinx.brownie.tapestry.components.form;

import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;

/**
 * @author takeshi
 */
public abstract class Focus extends AbstractComponent implements IScriptUser {

    private final ScriptWriter scriptWriter;

    public Focus() {
        super();
        this.scriptWriter = new ScriptWriter(this, "Focus.script");
        this.scriptWriter.setUsage(ScriptUsage.ONCE_BY_OBJECT);
    }

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        //no symbol
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        this.scriptWriter.execute(cycle);
    }

    public abstract String getFocusedTagId();

}