/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/24 13:25:08
 */
package org.asyrinx.brownie.tapestry.components.form;

import java.text.NumberFormat;
import java.text.ParseException;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.form.AbstractTextField;
import org.asyrinx.brownie.core.lang.NumberUtils;

/**
 * @author takeshi
 */
public abstract class NumberField extends AbstractTextField {

    public abstract IBinding getValueBinding();

    public abstract NumberFormat getFormat();

    public abstract Class getValueClass();

    public String readValue() {
        final Number number = (Number) getValueBinding().getObject("value", Number.class);
        if (number == null)
            return "0";
        final NumberFormat numberFormat = getFormat();
        if (numberFormat != null) {
            return numberFormat.format(number);
        } else {
            return String.valueOf(number);
        }
    }

    public void updateValue(String value) {
        if (StringUtils.isEmpty(value))
            value = "0";
        final NumberFormat numberFormat = getFormat();
        final Number original;
        if (numberFormat != null) {
            try {
                original = numberFormat.parse(value);
            } catch (ParseException e) {
                throw new ApplicationRuntimeException(e);
            }
        } else {
            original = NumberUtils.createNumber(value);
        }
        final Number number = NumberUtils.toNumber(original, getValueClass());
        getValueBinding().setObject(number);
    }

}