/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/22 17:50:14
 */
package org.asyrinx.brownie.tapestry.components.form;

import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.Submit;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;

/**
 * @author takeshi
 */
public abstract class SubmitAlias extends AbstractComponent implements IScriptUser {

    private final ScriptWriter scriptWriter;

    public SubmitAlias() {
        super();
        this.scriptWriter = new ScriptWriter(this, "SubmitAlias.script");
        this.scriptWriter.setUsage(ScriptUsage.ONCE_BY_OBJECT);
    }

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        symbols.put("idOnScript", getIdOnScript());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.tapestry.AbstractComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
     *      org.apache.tapestry.IRequestCycle)
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding())
            return;
        writer.beginEmpty("input");
        writer.attribute("type", "submit");
        writer.attribute("id", getIdOnScript());
        if (isDisabled())
            writer.attribute("disabled", "disabled");
        final String label = getLabel();
        if (label != null)
            writer.attribute("value", label);
        writer.attribute("onclick", buildOnClick(cycle));
        renderInformalParameters(writer, cycle);
        writer.closeTag();
        //
        if (isAutoActivate()) {
            this.scriptWriter.execute(cycle);
        }
    }

    protected String buildOnClick(IRequestCycle cycle) {
        final Submit submit = getSubmit();
        final IForm form = (submit.getForm() != null) ? submit.getForm() : Form.get(cycle);
        if (form == null)
            throw new ApplicationRuntimeException("Submit must be used with Form", this, null, null);
        final StringBuffer result = new StringBuffer();
        result.append("document.");
        result.append(form.getName());
        result.append(".");
        result.append(submit.getName());
        result.append(".click(); return false;");
        return result.toString();
    }

    public String getIdOnScript() {
        return getSubmit().getName() + "_alias";
    }

    public abstract String getLabel();

    public abstract boolean isDisabled();

    public abstract Submit getSubmit();

    public abstract boolean isAutoActivate();

}