/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/07 4:28:32
 */
package org.asyrinx.brownie.tapestry.components.subwindow;

import java.io.UnsupportedEncodingException;
import java.util.Map;

import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;

/**
 * @author takeshi
 */
public abstract class SubWindowLink extends BaseComponent {

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.tapestry.BaseComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
     *      org.apache.tapestry.IRequestCycle)
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        preparePageHref(cycle);
        super.renderComponent(writer, cycle);
    }

    private String pageHref = null;

    /**
     * @param cycle
     */
    private void preparePageHref(IRequestCycle cycle) {
        if (StringUtils.isEmpty(getTargetPage()))
            return;
        final ILink l = getLink(cycle);
        this.pageHref = constructURL(l, getAnchor(), cycle);
    }

    public ILink getLink(IRequestCycle cycle) {
        final INamespace namespace = getTargetNamespace();
        final String targetPage = getTargetPage();
        final String parameter = (namespace == null) ? targetPage : namespace.constructQualifiedName(targetPage);
        return getLink(cycle, Tapestry.PAGE_SERVICE, new String[] { parameter });
    }

    protected ILink getLink(IRequestCycle cycle, String serviceName, Object[] serviceParameters) {
        final IEngineService service = cycle.getEngine().getService(serviceName);
        return service.getLink(cycle, this, serviceParameters);
    }

    protected String constructURL(ILink link, String anchor, IRequestCycle cycle) {
        return link.getURL(anchor, true);
    }

    /** The default popup window name 'popuplink_window'. */
    public static final String DEFAULT_WINDOW_NAME = "subwindowlink_window";

    private static final URLCodec _urlCodec = new URLCodec();

    //	Instance variables
    private IBinding _hrefBinding;

    private IBinding _windowNameBinding;

    private IBinding _featuresBinding;

    public IBinding getHrefBinding() {
        return _hrefBinding;
    }

    public void setHrefBinding(IBinding hrefBinding) {
        _hrefBinding = hrefBinding;
    }

    public IBinding getWindowNameBinding() {
        return _windowNameBinding;
    }

    public void setWindowNameBinding(IBinding windowNameBinding) {
        _windowNameBinding = windowNameBinding;
    }

    public IBinding getFeaturesBinding() {
        return _featuresBinding;
    }

    public void setFeaturesBinding(IBinding featuresBinding) {
        _featuresBinding = featuresBinding;
    }

    public String getHref() {
        if (!StringUtils.isEmpty(this.pageHref)) {
            return this.pageHref;
        } else if (! isHrefEncoding()) {
            return this.getHrefBinding().getString();
        }
        IBinding aHrefBinding = getHrefBinding();
        if (aHrefBinding != null) {
            String encoding = getPage().getEngine().getOutputEncoding();
            try {
                return _urlCodec.encode(aHrefBinding.getString(), encoding);
            } catch (UnsupportedEncodingException e) {
                throw new ApplicationRuntimeException(Tapestry.format("illegal-encoding", encoding), e);
            }
        }
        return null;
    }

    public String getWindowName() {
        IBinding aWindowNameBinding = getWindowNameBinding();
        if (aWindowNameBinding != null) {
            return aWindowNameBinding.getString();
        } else {
            return DEFAULT_WINDOW_NAME;
        }
    }

    public String getFeatures() {
        IBinding aFeaturesBinding = getFeaturesBinding();
        if (aFeaturesBinding != null) {
            return aFeaturesBinding.getString();
        } else {
            return "";
        }
    }

    public String getPopupFunctionName() {
        return getIdPath().replace('.', '_') + "_click";
    }

    abstract public Map getFieldMapping();

    private String mappingSpanId = "property2field";

    public String getMappingSpanId() {
        return mappingSpanId;
    }

    public void setMappingSpanId(String mappingSpanId) {
        this.mappingSpanId = mappingSpanId;
    }

    public abstract boolean isHrefEncoding();

    public abstract INamespace getTargetNamespace();

    public abstract String getTargetPage();

    public abstract String getAnchor();
}