/*
 * brownie-tapestry-sample and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/07 7:07:34
 */
package org.asyrinx.brownie.tapestry.components.subwindow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

/**
 * @author takeshi
 */
public abstract class SubWindowSelectLink extends BaseComponent {

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.tapestry.BaseComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
     *      org.apache.tapestry.IRequestCycle)
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (!pageHasServer()) {
            //throw new ApplicationRuntimeException("SubWindowSelectLink
            // component must be used with SubWindowServer.",
            //        this, null, null);
            /*
             * SubWindowServery[WɊ܂܂ȂꍇAOoĂǁA@\𖳌ɂ悤ɎdlύXB
             */
            return;
        }
        this.renderedOnce = RENDERED_MARK.equals(cycle.getAttribute(this.getIdPath()));
        super.renderComponent(writer, cycle);
        cycle.setAttribute(this.getIdPath(), RENDERED_MARK);
    }

    private boolean pageHasServer() {
        for (Iterator i = getPage().getComponents().values().iterator(); i.hasNext();) {
            if (i.next() instanceof SubWindowServer)
                return true;
        }
        return false;
    }

    private boolean renderedOnce = false;

    public boolean isRenderedOnce() {
        return renderedOnce;
    }

    public String getSelectionFunctionName() {
        return getIdPath().replace('.', '_') + "_click";
    }

    public String getCloseVariableName() {
        return "closeWhen" + getSelectionFunctionName();
    }

    private static final String RENDERED_MARK = "rendered";

    private String mappingSpanId = "prop2value";

    public String getMappingSpanId() {
        return mappingSpanId;
    }

    public void setMappingSpanId(String mappingSpanId) {
        this.mappingSpanId = mappingSpanId;
    }

    abstract public Collection getProperties();

    abstract public Object getBean();

    abstract public boolean getCloseOnClick();

    public Map getBeanMap() {
        return (getProperties() != null) ? getBeanMapWithFilter() : getBeanMapNoFilter();
    }

    /**
     * @return
     */
    private Map getBeanMapWithFilter() {
        final Object bean = getBean();
        if (bean == null)
            return Collections.EMPTY_MAP;
        final Map result = new HashMap();
        for (Iterator i = getProperties().iterator(); i.hasNext();) {
            final String property = String.valueOf(i.next());
            final String value;
            try {
                value = BeanUtils.getProperty(bean, property);
            } catch (Exception e) {
                continue;
            }
            result.put(property, value);
        }
        return result;
    }

    /**
     * @return
     */
    private Map getBeanMapNoFilter() {
        final Object bean = getBean();
        if (bean == null)
            return Collections.EMPTY_MAP;
        try {
            return BeanUtils.describe(bean);
        } catch (Exception e) {
            throw new NestableRuntimeException(e);
        }
    }

}