/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/28 21:52:14
 */
package org.asyrinx.brownie.tapestry.valid;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.ValidatorException;

/**
 * @author takeshi
 */
public class ScriptValidator extends BaseValidator {

    protected ScriptValidator(String scriptPath) {
        this(scriptPath, String.class);
    }

    public ScriptValidator(String scriptPath, Class targetClass) {
        super();
        this.setClientScriptingEnabled(true);
        this.setScriptPath(scriptPath);
        this.setTargetClass(targetClass);
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        try {
            return ConvertUtils.convert(input, getTargetClass());
        } catch (ConversionException e) {
            throw new ValidatorException(e.getMessage());
        }
    }

    public String toString(IFormComponent field, Object value) {
        try {
            return ConvertUtils.convert(value);
        } catch (ConversionException e) {
            return (value == null) ? null : String.valueOf(value);
        }
    }

    private Class targetClass = String.class;

    public Class getTargetClass() {
        return targetClass;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer,
            IRequestCycle cycle) {
        renderScript(field, cycle);
    }

    protected void renderScript(IFormComponent field, IRequestCycle cycle) {
        if (!isClientScriptingEnabled())
            return;
        final Map symbols = prepareScriptSymbols();
        processValidatorScript(getScriptPath(), cycle, field, symbols);
    }

    protected void processValidatorScript(String scriptPath, IRequestCycle cycle,
            IFormComponent field, Map symbols) {
        final IEngine engine = field.getPage().getEngine();
        final IScriptSource source = engine.getScriptSource();
        final IForm form = field.getForm();
        final Map finalSymbols = (symbols == null) ? new HashMap() : symbols;
        finalSymbols.put(FIELD_SYMBOL, field);
        finalSymbols.put(FORM_SYMBOL, form);
        finalSymbols.put(VALIDATOR_SYMBOL, this);
        final IResourceLocation location = new ClasspathResourceLocation(engine
                .getResourceResolver(), scriptPath);
        final IScript script = source.getScript(location);
        final Body body = Body.get(cycle);
        if (body == null)
            throw new ApplicationRuntimeException(Tapestry
                    .getMessage("ValidField.must-be-contained-by-body"), field, null, null);
        script.execute(cycle, body, finalSymbols);
        //String functionName = (String) finalSymbols.get(FUNCTION_SYMBOL);
        //form.addEventHandler(FormEventType.SUBMIT, functionName);
    }

    /**
     * @return
     */
    protected Map prepareScriptSymbols() {
        final Map symbols = new HashMap();
        return symbols;
    }

    private String scriptPath = null;

    public String getScriptPath() {
        return scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }
}