/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/20 15:26:15
 */
package org.asyrinx.brownie.tapestry.wrapper;

import org.apache.tapestry.IMarkupWriter;

/**
 * @author takeshi
 */
public class MarkupWriterWrapper implements IMarkupWriter {

    /**
     *  
     */
    public MarkupWriterWrapper(IMarkupWriter wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final IMarkupWriter wrapped;

    public void attribute(String name, boolean value) {
        wrapped.attribute(name, value);
    }

    public void attribute(String name, int value) {
        wrapped.attribute(name, value);
    }

    public void attribute(String name, String value) {
        wrapped.attribute(name, value);
    }

    public void attributeRaw(String name, String value) {
        wrapped.attributeRaw(name, value);
    }

    public void begin(String name) {
        wrapped.begin(name);
    }

    public void beginEmpty(String name) {
        wrapped.beginEmpty(name);
    }

    public boolean checkError() {
        return wrapped.checkError();
    }

    public void close() {
        wrapped.close();
    }

    public void closeTag() {
        wrapped.closeTag();
    }

    public void comment(String value) {
        wrapped.comment(value);
    }

    public void end() {
        wrapped.end();
    }

    public void end(String name) {
        wrapped.end(name);
    }

    public void flush() {
        wrapped.flush();
    }

    public String getContentType() {
        return wrapped.getContentType();
    }

    public IMarkupWriter getNestedWriter() {
        return wrapped.getNestedWriter();
    }

    public void print(char value) {
        wrapped.print(value);
    }

    public void print(char[] data, int offset, int length) {
        wrapped.print(data, offset, length);
    }

    public void print(int value) {
        wrapped.print(value);
    }

    public void print(String value) {
        wrapped.print(value);
    }

    public void println() {
        wrapped.println();
    }

    public void printRaw(char[] buffer, int offset, int length) {
        wrapped.printRaw(buffer, offset, length);
    }

    public void printRaw(String value) {
        wrapped.printRaw(value);
    }
}