/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 11:46:10
 */
package org.asyrinx.brownie.validator.impl;

import java.util.Iterator;

import org.apache.commons.lang.enum.Enum;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;

/**
 * @author takeshi
 */
public abstract class CompositeType extends Enum {

    /**
     * @param name
     */
    public CompositeType(String name) {
        super(name);
    }

    public static final CompositeType AND = new CompositeType("and") {
        public void evaluate(CompositeValidator composite, ValidationContext context, Object obj) {
            final ValidationContext subContext = context.createSubContext();
            for (Iterator i = composite.iterator(); i.hasNext();) {
                final Validator v = (Validator) i.next();
                v.evaluate(subContext, obj);
            }
            if (!subContext.getMatters().isEmpty())
                context.addMessages(subContext);
        }
    };

    public static final CompositeType OR = new CompositeType("or") {
        public void evaluate(CompositeValidator composite, ValidationContext context, Object obj) {
            final ValidationContext subContext = context.createSubContext();
            for (Iterator i = composite.iterator(); i.hasNext();) {
                final Validator v = (Validator) i.next();
                int lastMessageSize = subContext.getMessages().size();
                v.evaluate(subContext, obj);
                if (lastMessageSize == subContext.getMessages().size())
                    return;
            }
            context.addMessages(subContext);
        }
    };

    public static CompositeType get(String name) {
        //return (CompositeType) Enum.getEnum(CompositeType.class, name);
        if ("and".equalsIgnoreCase(name))
            return AND;
        if ("or".equalsIgnoreCase(name))
            return OR;
        throw new UnsupportedOperationException("unknown CompositeType name:" + name);
    }

    /**
     * @param validator
     * @param context
     * @param obj
     */
    public abstract void evaluate(CompositeValidator validator, ValidationContext context,
            Object obj);

}