/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/04 17:20:59
 */
package org.asyrinx.brownie.validator.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.MessageLevel;

/**
 * @author takeshi
 */
public class MessageImpl implements Message {

    public MessageImpl(String text) {
        this(text, MessageLevel.ERROR);
    }

    public MessageImpl(String text, MessageLevel type) {
        super();
        this.text = text;
        this.type = type;
    }

    protected final String text;

    protected final MessageLevel type;

    public String getText() {
        return text;
    }

    public MessageLevel getLevel() {
        return type;
    }

    private List properties = null;

    public void addProperty(String propertyName) {
        if (this.properties == null)
            this.properties = new ArrayList();
        this.properties.add(propertyName);
    }

    public void clearProperties() {
        properties.clear();
    }

    public boolean containsProperty(String propertyName) {
        return properties.contains(propertyName);
    }

    public boolean isEmptyProperties() {
        return properties.isEmpty();
    }

    public Iterator iteratorProperties() {
        return properties.iterator();
    }

    public boolean removeProperty(String propertyName) {
        return properties.remove(propertyName);
    }

    public int sizeProperties() {
        return properties.size();
    }
}