/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 15:48:01
 */
package org.asyrinx.brownie.validator.prop;

import java.util.Map;
import java.util.regex.Pattern;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public class RegExp extends AbstractPropertyValidator {

    /**
     * @param propertyName
     * @param displayName
     */
    public RegExp(String propertyName, String displayName, String expression) {
        super(propertyName, displayName);
        this.expression = expression;
        this.pattern = Pattern.compile(expression);
    }

    private final String expression;

    private final Pattern pattern;

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (StringUtils.isEmpty((String) propertyValue))
            return;
        if (!pattern.matcher((String) propertyValue).matches())
            this.addError(context);
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("expression", this.expression);
    }

}