/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/05 15:59:15
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.Iterator;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.ClassKeyHashMap;
import org.asyrinx.brownie.core.collection.ClassKeyMap;

/**
 * @author takeshi
 */
public class ClassKeyHashMapTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ClassKeyHashMapTest.class);
    }

    public static interface IA {
    }

    public static interface IB extends IA {
    }

    public static interface IC extends IB {
    }

    public static interface ID extends IB {
    }

    public static interface IE {
    }

    public static interface IF extends IA {
    }

    public static interface IG extends IE {
    }

    public static class CA {
    }

    public static class CB extends CA {
    }

    public static class CC extends CB {
    }

    public static class CD extends CB implements IC {
    }

    public static class CE extends CB implements IE {
    }

    public static class CF extends CC implements IE, IB {
    }

    public static class CG extends CA implements IC {
    }

    public static class CH extends CA implements IE {
    }

    public static class CI extends CA implements IE, IB {
    }

    public static class CA2 extends CA {
    }

    public static class CB2 extends CB {
    }

    public static class CC2 extends CC {
    }

    public static class CD2 extends CD {
    }

    public static class CE2 extends CE {
    }

    public static class CF2 extends CF {
    }

    public static class CG2 extends CG {
    }

    public static class CH2 extends CH {
    }

    public static class CI2 extends CI {
    }

    public void testPut() {
        {
            final ClassKeyMap classKeyMap = new ClassKeyHashMap();
            assertEquals(true, classKeyMap.isEmpty());
            classKeyMap.put(IB.class, "IB");
            assertEquals(false, classKeyMap.isEmpty());
            classKeyMap.put(CB.class, "CB");
            checkClassKeyMap(classKeyMap);
        }
        {
            try {
                final ClassKeyMap classKeyMap = new ClassKeyHashMap();
                assertEquals(true, classKeyMap.isEmpty());
                classKeyMap.put(IB.class.getName(), "IB");
                assertEquals(false, classKeyMap.isEmpty());
                classKeyMap.put(CB.class.getName(), "CB");
                checkClassKeyMap(classKeyMap);
            } catch (ClassNotFoundException e1) {
                e1.printStackTrace();
                fail();
            }
        }
    }

    /**
     * @param classKeyMap
     */
    private void checkClassKeyMap(ClassKeyMap classKeyMap) {
        assertEquals(2, classKeyMap.size());
        assertEquals(true, classKeyMap.containsKey(IB.class));
        assertEquals(true, classKeyMap.containsKey(CB.class));
        assertEquals(true, classKeyMap.containsValue("IB"));
        assertEquals(true, classKeyMap.containsValue("CB"));
        assertEquals("IB", classKeyMap.get(IB.class));
        assertEquals("CB", classKeyMap.get(CB.class));
        assertEquals(2, classKeyMap.keySet().size());
        assertEquals(true, classKeyMap.keySet().contains(IB.class));
        assertEquals(true, classKeyMap.keySet().contains(CB.class));
        for (Iterator i = classKeyMap.keySet().iterator(); i.hasNext();) {
            final Object keyClass = i.next();
            assertEquals(true, keyClass instanceof Class);
        }
    }

    public void testGet() {
        final ClassKeyHashMap classKeyMap = new ClassKeyHashMap(new ClassKeyHashMap.LookingUpClassFirst());
        classKeyMap.put(IB.class, "IB");
        classKeyMap.put(CB.class, "CB");
        assertEquals(null, classKeyMap.get(IA.class));
        assertEquals("IB", classKeyMap.get(IB.class));
        assertEquals("IB", classKeyMap.get(IC.class));
        assertEquals("IB", classKeyMap.get(ID.class));
        assertEquals(null, classKeyMap.get(IE.class));
        assertEquals(null, classKeyMap.get(IF.class));
        assertEquals(null, classKeyMap.get(IG.class));
        assertEquals(null, classKeyMap.get(CA.class));
        assertEquals("CB", classKeyMap.get(CB.class));
        assertEquals("CB", classKeyMap.get(CC.class));
        assertEquals("CB", classKeyMap.get(CD.class));
        assertEquals("CB", classKeyMap.get(CE.class));
        assertEquals("CB", classKeyMap.get(CF.class));
        assertEquals("IB", classKeyMap.get(CG.class));
        assertEquals(null, classKeyMap.get(CH.class));
        assertEquals("IB", classKeyMap.get(CI.class));
        assertEquals(null, classKeyMap.get(CA2.class));
        assertEquals("CB", classKeyMap.get(CB2.class));
        assertEquals("CB", classKeyMap.get(CC2.class));
        assertEquals("CB", classKeyMap.get(CD2.class));
        assertEquals("CB", classKeyMap.get(CE2.class));
        assertEquals("CB", classKeyMap.get(CF2.class));
        assertEquals("IB", classKeyMap.get(CG2.class));
        assertEquals(null, classKeyMap.get(CH2.class));
        assertEquals("IB", classKeyMap.get(CI2.class));
        //
        classKeyMap.setLookingUp(new ClassKeyHashMap.LookingUpInterfaceFirst());
        assertEquals(null, classKeyMap.get(IA.class));
        assertEquals("IB", classKeyMap.get(IB.class));
        assertEquals("IB", classKeyMap.get(IC.class));
        assertEquals("IB", classKeyMap.get(ID.class));
        assertEquals(null, classKeyMap.get(IE.class));
        assertEquals(null, classKeyMap.get(IF.class));
        assertEquals(null, classKeyMap.get(IG.class));
        assertEquals(null, classKeyMap.get(CA.class));
        assertEquals("CB", classKeyMap.get(CB.class));
        assertEquals("CB", classKeyMap.get(CC.class));
        assertEquals("IB", classKeyMap.get(CD.class));
        assertEquals("CB", classKeyMap.get(CE.class));
        assertEquals("IB", classKeyMap.get(CF.class));
        assertEquals("IB", classKeyMap.get(CG.class));
        assertEquals(null, classKeyMap.get(CH.class));
        assertEquals("IB", classKeyMap.get(CI.class));
        assertEquals(null, classKeyMap.get(CA2.class));
        assertEquals("CB", classKeyMap.get(CB2.class));
        assertEquals("CB", classKeyMap.get(CC2.class));
        assertEquals("IB", classKeyMap.get(CD2.class));
        assertEquals("CB", classKeyMap.get(CE2.class));
        assertEquals("IB", classKeyMap.get(CF2.class));
        assertEquals("IB", classKeyMap.get(CG2.class));
        assertEquals(null, classKeyMap.get(CH2.class));
        assertEquals("IB", classKeyMap.get(CI2.class));
    }

}