/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package test.org.asyrinx.brownie.core.lang;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.ArrayUtils;

/**
 * @author akima
 */
public class ArrayUtilsTest extends TestCase {

	/**
	 * Constructor for ArrayUtilsTest.
	 * @param name
	 */
	public ArrayUtilsTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(ArrayUtilsTest.class);
	}

	public void testSubArray() {
		assertEquals(null, ArrayUtils.subArray(null, 0, 0));
		final Object[] data1 = new Object[] { "0", "1", "2", "3", "4" };
		final Object[] result1 = ArrayUtils.subArray(data1, 0, 2);
		assertEquals(2, result1.length);
		assertEquals("0", result1[0]);
		assertEquals("1", result1[1]);
		final Object[] result2 = ArrayUtils.subArray(data1, 1, 3);
		assertEquals(3, result2.length);
		assertEquals("1", result2[0]);
		assertEquals("2", result2[1]);
		assertEquals("3", result2[2]);
	}

	public void testToObjectArray() {
		final boolean[] booleanPrimitives =
			new boolean[] { true, false, false, true };
		final Object[] booleanObjects =
			ArrayUtils.toObjectArray(booleanPrimitives);
		assertEquals(4, booleanObjects.length);
		assertEquals(true, booleanObjects.getClass().isArray());
		assertEquals(
			Boolean.class,
			booleanObjects.getClass().getComponentType());
		assertEquals(true, ((Boolean) booleanObjects[0]).booleanValue());
		assertEquals(false, ((Boolean) booleanObjects[1]).booleanValue());
		assertEquals(false, ((Boolean) booleanObjects[2]).booleanValue());
		assertEquals(true, ((Boolean) booleanObjects[3]).booleanValue());

		final int[] intPrimitives = new int[] { 1, 2, 3 };
		final Object[] intObjects = ArrayUtils.toObjectArray(intPrimitives);
		assertEquals(3, intObjects.length);
		assertEquals(true, intObjects.getClass().isArray());
		assertEquals(Integer.class, intObjects.getClass().getComponentType());
		assertEquals(1, ((Integer) intObjects[0]).intValue());
		assertEquals(2, ((Integer) intObjects[1]).intValue());
		assertEquals(3, ((Integer) intObjects[2]).intValue());

		final long[] longPrimitives = new long[] { 65537, 77777, -777777 };
		final Object[] longObjects = ArrayUtils.toObjectArray(longPrimitives);
		assertEquals(3, longObjects.length);
		assertEquals(true, longObjects.getClass().isArray());
		assertEquals(Long.class, longObjects.getClass().getComponentType());
		assertEquals(65537, ((Long) longObjects[0]).longValue());
		assertEquals(77777, ((Long) longObjects[1]).longValue());
		assertEquals(-777777, ((Long) longObjects[2]).longValue());
	}

	public void testToPrimitiveArray() {
		final Boolean[] booleanObjects =
			new Boolean[] {
				Boolean.FALSE,
				Boolean.FALSE,
				Boolean.TRUE,
				Boolean.TRUE };
		Object object = ArrayUtils.toPrimitiveArray(booleanObjects);
		assertEquals(true, object.getClass().isArray());
		assertEquals(boolean.class, object.getClass().getComponentType());
		final boolean[] booleanPrimitives = (boolean[]) object;
		assertEquals(4, booleanPrimitives.length);
		assertEquals(false, booleanPrimitives[0]);
		assertEquals(false, booleanPrimitives[1]);
		assertEquals(true, booleanPrimitives[2]);
		assertEquals(true, booleanPrimitives[3]);

		final Integer[] intObjects =
			new Integer[] { new Integer(9), new Integer(11), new Integer(7)};
		object = ArrayUtils.toPrimitiveArray(intObjects);
		assertEquals(true, object.getClass().isArray());
		assertEquals(int.class, object.getClass().getComponentType());
		final int[] intPrimitives = (int[]) object;
		assertEquals(3, intPrimitives.length);
		assertEquals(9, intPrimitives[0]);
		assertEquals(11, intPrimitives[1]);
		assertEquals(7, intPrimitives[2]);

		final Long[] longObjects =
			new Long[] { new Long(-99999), new Long(112233), new Long(-881122)};
		object = ArrayUtils.toPrimitiveArray(longObjects);
		assertEquals(true, object.getClass().isArray());
		assertEquals(long.class, object.getClass().getComponentType());
		final long[] longPrimitives = (long[]) object;
		assertEquals(3, longPrimitives.length);
		assertEquals(-99999, longPrimitives[0]);
		assertEquals(112233, longPrimitives[1]);
		assertEquals(-881122, longPrimitives[2]);
	}

}
