/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/28 1:53:31
 */
package test.org.asyrinx.brownie.core.lang;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.FieldUtils;

/**
 * @author takeshi
 */
public class FieldUtilsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldUtilsTest.class);
    }

    /*
     * Class under test for Object getValue(Object, String)
     */
    public void testGetValueObjectString() {
        try {
            final A1 a1 = new A1();
            assertEquals("abc1", FieldUtils.getValue(a1, "value1"));
            assertEquals(new Integer(123), FieldUtils.getValue(a1, "value2"));
            assertEquals(new Integer(987), FieldUtils.getValue(a1, "VALUE_1"));
            final A2 a2 = new A2();
            assertEquals("abc1", FieldUtils.getValue(a2, "value1"));
            assertEquals(new Integer(123), FieldUtils.getValue(a2, "value2"));
            assertEquals(new Integer(987), FieldUtils.getValue(a2, "VALUE_1"));
            assertEquals(new Boolean(true), FieldUtils.getValue(a2, "booleanValue"));
            assertEquals("qwer", FieldUtils.getValue(a2, "value3"));
            assertEquals(new Long(654), FieldUtils.getValue(a2, "VALUE_B1"));
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
    }

    public void testGetStaticValue() {
        try {
            assertEquals(new Integer(987), FieldUtils.getStaticValue(A1.class, "VALUE_1"));
            assertEquals(new Integer(987), FieldUtils.getStaticValue(A2.class, "VALUE_1"));
            assertEquals(new Long(654), FieldUtils.getStaticValue(B1.class, "VALUE_B1"));
            assertEquals(new Long(654), FieldUtils.getStaticValue(A2.class, "VALUE_B1"));
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
    }

    public static class A1 {

        public String value1 = "abc1";

        public int value2 = 123;

        public static final int VALUE_1 = 987;

    }

    public static interface B1 {
        long VALUE_B1 = 654;
    }

    public static class A2 extends A1 implements B1 {

        public boolean booleanValue = true;

        public String value3 = "qwer";

    }

}