/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/12
 */
package test.org.asyrinx.brownie.core.lang;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.InvocationInfo;

/**
 * @author akima
 */
public class InvocationInfoTest extends TestCase {

	/**
	 * Constructor for InvocationInfoTest.
	 * @param name
	 */
	public InvocationInfoTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(InvocationInfoTest.class);
	}

	public void testLocationInfo() {
		/*
		 * This locationInfo has no filename and no lineNumber
		 * because this method is invoked by using reflection.
		 */

		//Exception e = new Exception("exeption to locate ");
		//e.printStackTrace();

		//		java.lang.Exception: exeption to locate 
		//			at test.org.asyrinx.lang.InvocationInfoTest.testLocationInfo(InvocationInfoTest.java:29)
		//			at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)
		//			at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:39)
		//			at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:25)
		//			at java.lang.reflect.Method.invoke(Method.java:324)
		//			at junit.framework.TestCase.runTest(TestCase.java:154)
		//			at junit.framework.TestCase.runBare(TestCase.java:127)
		//			at junit.framework.TestResult$1.protect(TestResult.java:106)
		//			at junit.framework.TestResult.runProtected(TestResult.java:124)
		//			at junit.framework.TestResult.run(TestResult.java:109)
		//			at junit.framework.TestCase.run(TestCase.java:118)
		//			at junit.framework.TestSuite.runTest(TestSuite.java:208)
		//			at junit.framework.TestSuite.run(TestSuite.java:203)
		//			at org.eclipse.jdt.internal.junit.runner.RemoteTestRunner.runTests(RemoteTestRunner.java:392)
		//			at org.eclipse.jdt.internal.junit.runner.RemoteTestRunner.run(RemoteTestRunner.java:276)
		//			at org.eclipse.jdt.internal.junit.runner.RemoteTestRunner.main(RemoteTestRunner.java:167)

		//		org.asyrinx.lang.InvocationInfo@2208288 {fileName=?, class=class org.asyrinx.lang.InvocationInfo, className=sun.reflect.NativeMethodAccessorImpl, methodName=invoke0, lineNumber=?}
		//		org.asyrinx.lang.InvocationInfo@17444196 {fileName=?, class=class org.asyrinx.lang.InvocationInfo, className=sun.reflect.NativeMethodAccessorImpl, methodName=invoke0, lineNumber=?}
		//		org.asyrinx.lang.InvocationInfo@19543842 {fileName=?, class=class org.asyrinx.lang.InvocationInfo, className=sun.reflect.NativeMethodAccessorImpl, methodName=invoke0, lineNumber=?}
		//		org.asyrinx.lang.InvocationInfo@24962279 {fileName=InvocationInfoTest.java, class=class org.asyrinx.lang.InvocationInfo, className=test.org.asyrinx.lang.InvocationInfoTest, methodName=invoke0_1, lineNumber=80}
		//		org.asyrinx.lang.InvocationInfo@13141056 {fileName=InvocationInfoTest.java, class=class org.asyrinx.lang.InvocationInfo, className=test.org.asyrinx.lang.Invoker1, methodName=invoke1_0, lineNumber=93}

		//InvocationInfo locationInfo =
		//	new InvocationInfo(new Exception(), this.getClass().getName());
		InvocationInfo locationInfo =
			new InvocationInfo(this.getClass().getName());
		InvocationInfoTest.check(
			locationInfo,
			"?",
			"sun.reflect.NativeMethodAccessorImpl",
			"invoke0",
			"?");
		invoke0_0();
	}

	public void invoke0_0() {
		//InvocationInfo locationInfo =
		//	new InvocationInfo(new Exception(), this.getClass().getName());
		InvocationInfo locationInfo =
			new InvocationInfo(this.getClass().getName());
		InvocationInfoTest.check(
			locationInfo,
			"?",
			"sun.reflect.NativeMethodAccessorImpl",
			"invoke0",
			"?");
		invoke0_1();
	}

	public void invoke0_1() {
		//InvocationInfo locationInfo =
		//	new InvocationInfo(new Exception(), this.getClass().getName());
		InvocationInfo locationInfo =
			new InvocationInfo(this.getClass().getName());
		InvocationInfoTest.check(
			locationInfo,
			"?",
			"sun.reflect.NativeMethodAccessorImpl",
			"invoke0",
			"?");
		Invoker1 invoker1 = new Invoker1();
		invoker1.invoke1_0();
	}

	public static void check(
		InvocationInfo info,
		String filename,
		String className,
		String method,
		String lineNumber) {
		TestCase.assertEquals(filename, info.getFileName());
		TestCase.assertEquals(className, info.getClassName());
		TestCase.assertEquals(method, info.getMethodName());
		TestCase.assertEquals(lineNumber, info.getLineNumber());
	}
}
class Invoker1 extends TestCase {
	public Invoker1() {
		super();
	}
	public void invoke1_0() {
		//InvocationInfo locationInfo =
		//	new InvocationInfo(new Exception(), this.getClass().getName());
		InvocationInfo locationInfo =
			new InvocationInfo(this.getClass().getName());
		InvocationInfoTest.check(
			locationInfo,
			"InvocationInfoTest.java",
			"test.org.asyrinx.brownie.core.lang.InvocationInfoTest",
			"invoke0_1",
			"103");
		Invoker2 invoker2 = new Invoker2();
		invoker2.invoke2_0();
	}
}
class Invoker2 extends TestCase {
	public Invoker2() {
		super();
	}
	public void invoke2_0() {
		//InvocationInfo locationInfo =
		//	new InvocationInfo(new Exception(), this.getClass().getName());
		InvocationInfo locationInfo =
			new InvocationInfo(this.getClass().getName());
		InvocationInfoTest.check(
			locationInfo,
			"InvocationInfoTest.java",
			"test.org.asyrinx.brownie.core.lang.Invoker1",
			"invoke1_0",
			"134");
	}
}
