/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/09 13:41:11
 */
package test.org.asyrinx.brownie.core.lang;

import java.io.UnsupportedEncodingException;
import java.util.Properties;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.StringUtils;

import sun.io.Converters;

/**
 * @author akima
 */
public class StringUtilsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(StringUtilsTest.class);
    }

    public void testDeleteNotNumeric() {
        assertEquals(null, StringUtils.deleteNotNumeric(null));
        assertEquals("", StringUtils.deleteNotNumeric("abc*)(N"));
        assertEquals("0987-234", StringUtils.deleteNotNumeric("abc0987-234"));
        assertEquals("-234", StringUtils.deleteNotNumeric("abc-234fghj"));
    }

    public void testDeleteNotNumber() {
        assertEquals(null, StringUtils.deleteNotNumber(null));
        assertEquals("", StringUtils.deleteNotNumber("abc*)(N"));
        assertEquals("0987234", StringUtils.deleteNotNumber("abc0987-234"));
        assertEquals("234", StringUtils.deleteNotNumber("abc-234fghj"));
    }

    /*
     * Class under test for boolean isNumeric(char)
     */
    public void testIsNumericchar() {
        assertEquals(false, StringUtils.isNumeric('-'));
        assertEquals(false, StringUtils.isNumeric('+'));
        assertEquals(false, StringUtils.isNumeric('*'));
        assertEquals(false, StringUtils.isNumeric('a'));
        assertEquals(true, StringUtils.isNumeric('0'));
        assertEquals(true, StringUtils.isNumeric('1'));
        assertEquals(true, StringUtils.isNumeric('2'));
        assertEquals(true, StringUtils.isNumeric('9'));
        assertEquals(true, StringUtils.isNumeric('O'));
        assertEquals(true, StringUtils.isNumeric('P'));
        assertEquals(true, StringUtils.isNumeric('Q'));
        assertEquals(true, StringUtils.isNumeric('X'));
    }

    public void testHasNumeric() {
        assertEquals(false, StringUtils.hasNumeric(null));
        assertEquals(false, StringUtils.hasNumeric(""));
        assertEquals(false, StringUtils.hasNumeric("abc"));
        assertEquals(true, StringUtils.hasNumeric("123"));
        assertEquals(true, StringUtils.hasNumeric("VWX"));
        assertEquals(true, StringUtils.hasNumeric("adf56"));
        assertEquals(true, StringUtils.hasNumeric("VWX"));
    }

    public void testIsNumericOnly() {
        assertEquals(false, StringUtils.isNumericOnly(null));
        assertEquals(false, StringUtils.isNumericOnly(""));
        assertEquals(false, StringUtils.isNumericOnly("abc"));
        assertEquals(true, StringUtils.isNumericOnly("123"));
        assertEquals(false, StringUtils.isNumericOnly("VWX"));
        assertEquals(false, StringUtils.isNumericOnly("adf56"));
        assertEquals(true, StringUtils.isNumericOnly("VWX"));
    }

    /*
     * Class under test for String replaceWithProperties(String, Properties)
     */
    public void testReplaceWithPropertiesStringProperties() {
        assertEquals(null, StringUtils.replaceWithProperties(null, null));
        assertEquals(null, StringUtils.replaceWithProperties(null, new Properties()));
        final Properties properties = new Properties();
        properties.setProperty("abc", "ABC");
        properties.setProperty("def", "DEF");
        properties.setProperty("jkl", "JKL");
        assertEquals("ABC", StringUtils.replaceWithProperties("${abc}", properties));
        assertEquals("ABCABC", StringUtils.replaceWithProperties("${abc}${abc}", properties));
        assertEquals("abcDEFghi", StringUtils.replaceWithProperties("abc${def}ghi", properties));
        assertEquals("abcDEFghiJKL", StringUtils.replaceWithProperties("abc${def}ghi${jkl}", properties));
        assertEquals("", StringUtils.replaceWithProperties("${abcd}", properties));
    }

    /*
     * Class under test for String replaceWithProperties(String, Properties,
     * String, String)
     */
    public void testReplaceWithPropertiesStringPropertiesStringString() {
        assertEquals(null, StringUtils.replaceWithProperties(null, null, null, null));
        assertEquals(null, StringUtils.replaceWithProperties(null, new Properties(), null, null));
        final Properties properties = new Properties();
        properties.setProperty("abc", "ABC");
        properties.setProperty("def", "DEF");
        properties.setProperty("jkl", "JKL");
        try {
            assertEquals("ABC", StringUtils.replaceWithProperties("${abc}", properties, null, null));
            fail();
        } catch (UnsupportedOperationException e) {
            assertTrue(true);
        }
        try {
            assertEquals("ABC", StringUtils.replaceWithProperties("${abc}", properties, "", ""));
            fail();
        } catch (UnsupportedOperationException e) {
            assertTrue(true);
        }
        try {
            assertEquals("ABC", StringUtils.replaceWithProperties("${abc}", properties, "$", ""));
            fail();
        } catch (UnsupportedOperationException e) {
            assertTrue(true);
        }
        try {
            assertEquals("ABC", StringUtils.replaceWithProperties("${abc}", properties, "", "$"));
            fail();
        } catch (UnsupportedOperationException e) {
            assertTrue(true);
        }
        assertEquals("abcDEFghi", StringUtils.replaceWithProperties("abc%def%ghi", properties, "%", "%"));
        assertEquals("abcDEFghi${jkl}", StringUtils.replaceWithProperties("abc%def%ghi${jkl}", properties, "%", "%"));
        assertEquals("", StringUtils.replaceWithProperties("%abcd%", properties, "%", "%"));
    }

    public void testReplace() {
        assertEquals("abcdef", StringUtils.replace("abc\ndef", "\n", ""));
    }

    /*
     * Class under test for String extractString(String, String, String)
     */
    public void testExtractStringStringStringString() {
    }

    /*
     * Class under test for String extractString(String, String, String, int)
     */
    public void testExtractStringStringStringStringint() {
    }

    /*
     * Class under test for void extractStrings(String, List, char)
     */
    public void testExtractStringsStringListchar() {
    }

    /*
     * Class under test for void extractStrings(String, List, char, char)
     */
    public void testExtractStringsStringListcharchar() {
    }

    /*
     * Class under test for void extractStrings(String, List, char, char, int)
     */
    public void testExtractStringsStringListcharcharint() {
    }

    /*
     * Class under test for String nullTrim(Object)
     */
    public void testNullTrimObject() {
    }

    /*
     * Class under test for String nullTrim(Object, boolean)
     */
    public void testNullTrimObjectboolean() {
    }

    /*
     * Class under test for String nullTrim(Object[])
     */
    public void testNullTrimObjectArray() {
    }

    /*
     * Class under test for String nullTrim(Object[], boolean)
     */
    public void testNullTrimObjectArrayboolean() {
    }

    public void testCompare() {
    }

    public void testParseToList() {
    }

    /*
     * Class under test for void tokenize(List, String, String)
     */
    public void testTokenizeListStringString() {
    }

    public void testTokenizeToArray() {
    }

    /*
     * Class under test for List tokenize(String, String)
     */
    public void testTokenizeStringString() {
    }

    /*
     * Class under test for int indexOf(char[], char)
     */
    public void testIndexOfcharArraychar() {
    }

    public void testContainAnyChar() {
    }

    /*
     * Class under test for String duplicateQuote(String, char[], boolean)
     */
    public void testDuplicateQuoteStringcharArrayboolean() {
    }

    /*
     * Class under test for String duplicateQuote(String, char[])
     */
    public void testDuplicateQuoteStringcharArray() {
    }

    /*
     * Class under test for String duplicateQuote(String, char, boolean)
     */
    public void testDuplicateQuoteStringcharboolean() {
    }

    /*
     * Class under test for String duplicateQuote(String, char)
     */
    public void testDuplicateQuoteStringchar() {
    }

    /*
     * Class under test for String toQuoted(String, char, boolean)
     */
    public void testToQuotedStringcharboolean() {
    }

    /*
     * Class under test for String toQuoted(String, char)
     */
    public void testToQuotedStringchar() {
    }

    public void testPadHead() {
    }

    public void testPadTail() {
    }

    /*
     * Class under test for String getPackageAsPath(String)
     */
    public void testGetPackageAsPathString() {
    }

    /*
     * Class under test for String getPackageAsPath(String, String)
     */
    public void testGetPackageAsPathStringString() {
    }

    /*
     * Class under test for String valueOf(Object)
     */
    public void testValueOfObject() {
    }

    /*
     * Class under test for String valueOf(byte)
     */
    public void testValueOfbyte() {
    }

    /*
     * Class under test for String valueOf(short)
     */
    public void testValueOfshort() {
    }

    /*
     * Class under test for String valueOf(int)
     */
    public void testValueOfint() {
    }

    /*
     * Class under test for String valueOf(long)
     */
    public void testValueOflong() {
    }

    /*
     * Class under test for String valueOf(double)
     */
    public void testValueOfdouble() {
    }

    /*
     * Class under test for String valueOf(float)
     */
    public void testValueOffloat() {
    }

    /*
     * Class under test for String valueOf(char)
     */
    public void testValueOfchar() {
    }

    /*
     * Class under test for String valueOf(boolean)
     */
    public void testValueOfboolean() {
    }

    public void testJoinIfValueNotNull() {
        assertEquals(null, StringUtils.joinIfValueNotNull(null, null, null));
        assertEquals(null, StringUtils.joinIfValueNotNull(null, "aaa", null));
        assertEquals(null, StringUtils.joinIfValueNotNull(null, null, "bbb"));
        assertEquals(null, StringUtils.joinIfValueNotNull(null, "aaa", "bbb"));
        assertEquals(null, StringUtils.joinIfValueNotNull("", null, null));
        assertEquals(null, StringUtils.joinIfValueNotNull("", "aaa", null));
        assertEquals(null, StringUtils.joinIfValueNotNull("", null, "bbb"));
        assertEquals(null, StringUtils.joinIfValueNotNull("", "aaa", "bbb"));
        assertEquals("111", StringUtils.joinIfValueNotNull("111", null, null));
        assertEquals("aaa111", StringUtils.joinIfValueNotNull("111", "aaa", null));
        assertEquals("111bbb", StringUtils.joinIfValueNotNull("111", null, "bbb"));
        assertEquals("aaa111bbb", StringUtils.joinIfValueNotNull("111", "aaa", "bbb"));
    }

    public void testGetByteSize() {
        try {
            assertEquals(3, "".length());
            //charsetNamenull̏ꍇ́AConverters.getDefaultEncodingName()g
            assertEquals(0, StringUtils.getByteSize(null, null));
            assertEquals(0, StringUtils.getByteSize("", null));
            assertEquals(6, StringUtils.getByteSize("", null));
            assertEquals(10, StringUtils.getByteSize("fO", "MS932"));
            assertEquals(8, StringUtils.getByteSize("modeling", "MS932"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            fail();
        }

    }
}