/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 15:21:07
 */
package test.org.asyrinx.brownie.core.resource.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import org.asyrinx.brownie.core.resource.impl.PropertiesMessageResource;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class PropertiesMessageResourceTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(PropertiesMessageResourceTest.class);
    }

    private static final String KEY1 = "org.asyrinx.brownie.core.resource.impl.test.value1";

    private static final String KEY2 = "org.asyrinx.brownie.core.resource.impl.test.value2";

    public void testGetMessage() {
        final Properties properties = new Properties();
        properties.setProperty(KEY1, "");
        properties.setProperty(KEY2, "");
        final File textFile;
        try {
            textFile = File.createTempFile("brownie-test", ".properties");
            properties.store(new FileOutputStream(textFile), "");
        } catch (IOException e) {
            e.printStackTrace();
            fail();
            return;
        }
        final PropertiesMessageResource messageResource = new PropertiesMessageResource(textFile.getPath());
        assertEquals("", messageResource.getMessage(KEY1));
        assertEquals("", messageResource.getMessage(KEY2));
    }

}