/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/21
 */
package test.org.asyrinx.brownie.core.sql2;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.brownie.core.sql2.Select;

/**
 * @author akima
 */
public class SelectTest extends TestCase {

	/**
	 * Constructor for DynamicSelectTest.
	 * @param name
	 */
	public SelectTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(SelectTest.class);
	}

	public void testSimpleSQL1() {
		final Select select = new Select();
		select.getSelectFields().add("a");
		select.getSelectFields().add("b");
		select.getSelectFields().add("c");
		select.getFromTables().add("A1");
		select.getWhereConditions().add("d", 1);
		//System.out.println(select.toSql());
		assertEquals("select a, b, c from A1 where d = 1", select.toSql());
	}

	public void testSimpleHQL1() {
		final Select select = new Select();
		select.getFromTables().add("A1");
		select.getWhereConditions().add("d", 1);
		//System.out.println(select.build());
		assertEquals("from A1 where d = 1", select.toSql());
	}

	public void testSimpleComplexCondition() {
		final Select select = new Select();
		select.getSelectFields().add("a").add("b").add("c");
		select.getFromTables().add("A1");
		select
			.getWhereConditions()
			.add("d", 1)
			.addNewConditions(Operator.OR)
			.add("a", 123)
			.add("b", 456)
			.addNewConditions(Operator.AND)
			.add("c", 789)
			.add("d", 1234);
		select.getWhereConditions().add("e", 2);
		//System.out.println(select.toSql());
		assertEquals(
			"select a, b, c from A1 where d = 1 and (a = 123 or b = 456 or (c = 789 and d = 1234)) and e = 2",
			select.toSql());
	}

	public void testSimpleComplexCondition2() {
		final Select select = new Select();
		select.getSelectFields().add("a").add("b").add("c");
		select.getFromTables().add("A1");
		select
			.getWhereConditions()
			.add("d", "1")
			.addNewConditions(Operator.OR)
			.add("a", 123)
			.add("b", "456")
			.addNewConditions(Operator.AND)
			.add("c", "789")
			.add("d", 1234);
		select.getWhereConditions().add("e", 2);
		//System.out.println(select.toSql());
		assertEquals(
			"select a, b, c from A1 where d = '1' and (a = 123 or b = '456' or (c = '789' and d = 1234)) and e = 2",
			select.toSql());
	}

	public void testSimpleComplexCondition3() {
		final Select select = new Select();
		select.getSelectFields().add("a").add("b").add("c");
		select.getFromTables().add("A1");

		select
			.getWhereConditions()
			.add("d", "1")
			.addNewConditions(Operator.OR)
			.add("a", new int[] { 1, 2, 3 }, Operator.IN)
			.add("b", "456")
			.addNewConditions(Operator.AND)
			.add("c", new char[] { '7', '8', '9' }, Operator.IN)
			.add("d", new String[] { "12", "34" }, Operator.IN);
		select.getWhereConditions().add("e", 2);
		//System.out.println(select.toSql());
		assertEquals(
			"select a, b, c from A1 "
				+ "where "
				+ "d = '1' and "
				+ "(a in (1, 2, 3) or "
				+ "b = '456' or (c in ('7', '8', '9') and d in ('12', '34'))) "
				+ "and e = 2",
			select.toSql());
	}

	public void testSimpleComplexCondition4() {
		final Select select = new Select();
		select.getSelectFields().add("a").add("b").add("c");
		select.getFromTables().add("A1");

		select
			.getWhereConditions()
			.add("d", "1")
			.addNewConditions(Operator.OR)
			.add("a", new int[] { 1, 2, 3 }, Operator.IN)
			.add("b", "456")
			.addNewConditions(Operator.AND)
			.add("c", new char[] { '7', '8', '9' }, Operator.IN)
			.add("d", new String[] {
		}, Operator.IN);
		select.getWhereConditions().add("e", 2);
		//System.out.println(select.toSql());
		assertEquals(
			"select a, b, c from A1 "
				+ "where "
				+ "d = '1' and "
				+ "(a in (1, 2, 3) or "
				+ "b = '456' or (c in ('7', '8', '9'))) "
				+ "and e = 2",
			select.toSql());
	}

}
