/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 23:16:02
 */
package test.org.asyrinx.brownie.core.text;

import java.util.HashMap;
import java.util.Map;

import org.asyrinx.brownie.core.text.MapMessageFormat;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class MapMessageFormatTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MapMessageFormatTest.class);
    }

    public void testParse() {
        //unsupported
    }

    public void testFormat() {
        final MapMessageFormat format = new MapMessageFormat(
                "property '${prop1}' must be ${value1}");
        //
        final Map parameters = new HashMap();
        parameters.put("prop1", "NAME");
        parameters.put("value1", "your name");
        assertEquals("property 'NAME' must be your name", format.format(parameters));
        //
        parameters.remove("prop1");
        assertEquals("property '${prop1}' must be your name", format.format(parameters));
    }

}