/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 17:54:55
 */
package test.org.asyrinx.brownie.core.text.jp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class HankakuTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(HankakuTest.class);
    }

    public void testHankaku() {
        final Map characterSets = new HashMap();
        characterSets
                .put(
                        "pJ^Ji",
                        "޷޸޹޺޻޼޽޾޿ߦ");
        characterSets
                .put("SpЂ炪",
                        "Âłǂ΂тԂׂڂς҂Ղ؂ۂ[ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂");
        characterSets
                .put("SpJ^Ji",
                        "KMOQSUWY[]_adfhorux{psvy|@BDFHb[ACEGIJLNPRTVXZ\^`cegijklmnqtwz}~");
        for (Iterator i = characterSets.keySet().iterator(); i.hasNext();) {
            final String name = (String) i.next();
            final String value = (String) characterSets.get(name);
            searchMinMax(name, value);
        }
    }

    /**
     * @param name
     * @param value
     */
    private void searchMinMax(String name, String value) {
        Character min = null;
        Character max = null;
        for (int i = 0; i < value.length(); i++) {
            final char c = value.charAt(i);
            min = (min == null) ? new Character(c) : (min.charValue() > c) ? new Character(c) : min;
            max = (max == null) ? new Character(c) : (max.charValue() < c) ? new Character(c) : max;
        }
        System.out.println(name + " min:'" + min + "'  max:'" + max + "'");
    }

    public void testPrint() {
        System.out.println("pJ^Ji: " + makeStr('', ''));
        System.out.println("SpЂ炪: " + makeStr('@', 'S'));
        System.out.println("SpJ^Ji: " + makeStr('', ''));
        System.out.println("Sp: " + makeStr('O', 'X'));
        //System.out.println(": " + makeStr('Z', ''));
        System.out.println("[}啶: " + makeStr('T', ']'));
        System.out.println("[}: " + makeStr('@', 'I'));
        System.out.println("SpAt@xbg: " + makeStr('', ''));
        System.out.println("SpAt@xbg啶: " + makeStr('`', 'y'));
    }

    private String makeStr(char min, char max) {
        final StringBuffer result = new StringBuffer();
        for (int i = 0; i < 10; i++)
            min--;
        for (char c = min; c <= max + 10; c++) {
            result.append(c);
        }
        return result.toString();
    }

}