package test.org.asyrinx.brownie.pdf.fop.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Party [ p[eB ]
 * 
 * @hibernate.class table="${table.getName()}"
 */
public class Party implements Serializable {

    public Party() {
        super();
    }

    public Party(long partyId, String partyCode, String name, String nameKana) {
        super();
        this.partyId = partyId;
        this.partyCode = partyCode;
        this.name = name;
        this.nameKana = nameKana;
    }

    /* --------------------Properties -------------------- */
    /** partyId [ p[eBID ] */
    private long partyId = 0;

    /** partyCode [ p[eBR[h ] */
    private String partyCode = null;

    /** name [ O ] */
    private String name = null;

    /** nameKana [ Ji ] */
    private String nameKana = null;

    /**
     * Get the partyId [ p[eBID ]
     * 
     * @return long
     */
    public long getPartyId() {
        return partyId;
    }

    /**
     * Get the partyCode [ p[eBR[h ]
     * 
     * @return String
     */
    public String getPartyCode() {
        return partyCode;
    }

    /**
     * Get the name [ O ]
     * 
     * @return String
     */
    public String getName() {
        return name;
    }

    /**
     * Get the nameKana [ Ji ]
     * 
     * @return String
     */
    public String getNameKana() {
        return nameKana;
    }

    /**
     * Set the partyId [ p[eBID ]
     * 
     * @param value
     *            new value
     */
    public void setPartyId(long value) {
        this.partyId = value;
    }

    /**
     * Set the partyCode [ p[eBR[h ]
     * 
     * @param value
     *            new value
     */
    public void setPartyCode(String value) {
        this.partyCode = value;
    }

    /**
     * Set the name [ O ]
     * 
     * @param value
     *            new value
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Set the nameKana [ Ji ]
     * 
     * @param value
     *            new value
     */
    public void setNameKana(String value) {
        this.nameKana = value;
    }

    /* --------------------Referring Objects -------------------- */

    /* --------------------Referred Objects -------------------- */

    private Set partyTelephones = null;

    protected void setPartyTelephonesInternal(Set partyTelephones) {
        this.partyTelephones = partyTelephones;
    }

    protected Set getPartyTelephonesInternal() {
        if (this.partyTelephones == null) {
            this.partyTelephones = new HashSet();
        }
        return this.partyTelephones;
    }

    public List getPartyTelephones() {
        //final List sortedPartyTelephones = new
        // ArrayList(getPartyTelephonesInternal());
        //PropertyComparator.sort(sortedPartyTelephones, new
        // MutableSortDefinition("name", true, true));
        //return Collections.unmodifiableList(sortedPartyTelephones);
        return Collections.unmodifiableList(new ArrayList(getPartyTelephonesInternal()));
    }

    /**
     * Add a PartyTelephone to the List of partyTelephones.
     * 
     * @param $paramNameLow
     *            New ${refTable.getJavaName()} to be added to the List of
     *            partyTelephones
     */
    public void addPartyTelephone(PartyTelephone partyTelephone) {
        getPartyTelephonesInternal().add(partyTelephone);
    }

    /**
     * remove a PartyTelephone to the List of partyTelephones.
     * 
     * @param partyTelephone
     *            PartyTelephone to be removed to the List of partyTelephones
     */
    public void removePartyTelephone(PartyTelephone partyTelephone) {
        getPartyTelephonesInternal().remove(partyTelephone);
    }

    /**
     * returns an id that differentiates this object from others of its class.
     */
    public Serializable getPrimaryKey() {
        return new Long(getPartyId());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Party))
            return false;
        Party castOther = (Party) other;
        return new EqualsBuilder().append(this.getPartyId(), castOther.getPartyId()).append(this.getPartyCode(),
                castOther.getPartyCode()).append(this.getName(), castOther.getName()).append(this.getNameKana(),
                castOther.getNameKana()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getPartyId()).append(this.getPartyCode()).append(this.getName())
                .append(this.getNameKana()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("partyId", this.getPartyId()).append("partyCode", this.getPartyCode())
                .append("name", this.getName()).append("nameKana", this.getNameKana()).toString();
    }

}