/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 10:56:47
 */
package test.org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.prop.MaxByteLength;

import test.org.asyrinx.brownie.validator.JapaneseTestCase;
import test.org.asyrinx.brownie.validator.TestObject;
import test.org.asyrinx.brownie.validator.TestUtils;

/**
 * @author takeshi
 */
public class MaxByteLengthTest extends JapaneseTestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MaxByteLengthTest.class);
    }

    public void testUsual() {
        final Validator v = new MaxByteLength("stringProperty", "񑮐", 10);
        //
        final TestObject object1 = new TestObject();
        object1.setStringProperty(null);
        //
        TestUtils.assertOK(v, object1);
        //
        ValidationContext context;
        Message message;
        //
        object1.setStringProperty("0123456789"); //OK
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("01234567890"); //boo!
        context = TestUtils.assertNG(v, object1, 1);
        message = (Message) context.getMessages().get(0);
        assertEquals("񑮐 ͔p 10 (SpȂ炻1/2)܂œ͉\łB", message.getText());
        //
        object1.setStringProperty(""); //OK
        TestUtils.assertOK(v, object1);
        object1.setStringProperty("1"); //boo!
        TestUtils.assertNG(v, object1, 1);
    }

}