/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 14:59:03
 */
package org.asyrinx.joey.gen.ant;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.xml.XmlToRdb;
import org.xml.sax.SAXException;

/**
 * @author takeshi
 */
public class DatabasesLoaderImpl implements DatabasesLoader {

    /**
     *  
     */
    public DatabasesLoaderImpl(XmlToRdb xmlToRdb) {
        super();
        this.xmlToRdb = xmlToRdb;
    }

    private final XmlToRdb xmlToRdb;

    public Databases load(List filesets, Project project) throws IOException, SAXException {
        final Databases databases = new Databases();
        // Deal with the filesets.
        for (int i = 0; i < filesets.size(); i++) {
            final FileSet fs = (FileSet) filesets.get(i);
            final File srcDir = fs.getDir(project);
            final DirectoryScanner ds = fs.getDirectoryScanner(project);
            final String[] dataModelFiles = ds.getIncludedFiles();
            for (int j = 0; j < dataModelFiles.length; j++) {
                final File f = new File(srcDir, dataModelFiles[j]);
                final Databases loaded = loadModelXmlFile(f.toString());
                databases.appendDatabases(loaded);
            }
        }
        return databases;
    }

    protected Databases loadModelXmlFile(String filename) throws IOException, SAXException {
        return xmlToRdb.load(filename);
    }

}