/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/12 14:42:21
 */
package org.asyrinx.joey.gen.ant;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.tools.ant.Project;
import org.asyrinx.joey.gen.command.rdb2java.Rdb2JavaBuilder;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.xml.sax.SAXException;

/**
 * @author takeshi
 */
public class ModelLoaderImpl implements ModelLoader {

    /**
     *  
     */
    public ModelLoaderImpl(DatabasesLoader databasesLoader, Rdb2JavaBuilder builder) {
        super();
        this.databasesLoader = databasesLoader;
        this.builder = builder;
    }

    final Rdb2JavaBuilder builder;

    final DatabasesLoader databasesLoader;

    /**
     * @param filesets
     * @param project
     * @return
     * @throws SAXException
     * @throws IOException
     */
    public Databases loadDatabaseModels(List filesets, Project project) throws IOException, SAXException {
        final Databases result = databasesLoader.load(filesets, project);
        return result;
    }

    /**
     * @param databases
     * @param project
     * @return
     */
    public AppDomain loadAppDomainModel(Databases databases, Project project) {
        builder.setProperties(Collections.unmodifiableMap(project.getProperties()));
        final AppDomain domain = builder.execute(databases);
        return domain;
    }

    /**
     * @return
     */
    public Map getRdb2Java() {
        return builder.getRdb2Java();
    }

}