/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/20 12:59:01
 */
package org.asyrinx.joey.gen.ant.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import ognl.OgnlRuntime;

import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.Generator;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.ant.ModelLoader;
import org.asyrinx.joey.gen.core.JoeyGenerateTarget;
import org.asyrinx.joey.gen.core.JoeyVelocityGenerator;
import org.asyrinx.joey.gen.core.VelocityHelper;
import org.asyrinx.joey.gen.core.VelocityOgnlAccessor;
import org.asyrinx.joey.gen.core.VelocityOgnlHelper;
import org.asyrinx.joey.gen.core.impl.S2ContainerLoader;
import org.asyrinx.joey.gen.hibernate.HibernateUtils;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.seasar.framework.container.S2Container;
import org.xml.sax.SAXException;

/**
 * @author takeshi
 */
public class JoeyGenerateTask extends MultiTargetTexenTask {

    private S2Container container = S2ContainerLoader.getContainer();

    public Context initControlContext() {
        if (filesets.isEmpty())
            throw new BuildException("There's no schema file. You must specify fileset of schema files!");
        final Context result = new VelocityContext();
        try {
            loadModels(result);
        } catch (Exception e) {
            throw new BuildException(e);
        }
        return result;
    }

    private Generator generator = null;

    protected Generator initGenerator() {
        if (this.generator == null) {
            final Object gen = container.getComponent(JoeyVelocityGenerator.class);
            if (gen instanceof Generator)
                this.generator = (Generator) gen;
            else
                throw new BuildException("JoeyVelocityGenerator object must extends " + Generator.class.getName());
        }
        return this.generator;
    }

    private SchemaBackup schemaBackup = new SchemaBackup();

    //protected Context context;

    private void loadModels(Context context) throws IOException, SAXException {
        final ModelLoader modelLoader = (ModelLoader) container.getComponent(ModelLoader.class);
        final Databases databases = modelLoader.loadDatabaseModels(filesets, this.project);
        final AppDomain domain = modelLoader.loadAppDomainModel(databases, this.project);
        final Map rdb2Java = modelLoader.getRdb2Java();
        //
        schemaBackup.execute(this.project, filesets, lastSchemaDir);
        //
        context.put("databases", databases);
        context.put("domain", domain);
        context.put("rdb2java", rdb2Java);
        context.put("helper", new VelocityHelper(context));
        context.put("ognl", new VelocityOgnlHelper(context));
        context.put("stringUtils", new org.asyrinx.brownie.core.lang.StringUtils());
        context.put("hibernateUtils", new HibernateUtils());
        OgnlRuntime.setPropertyAccessor(Map.class, new VelocityOgnlAccessor(context));
    }

    private List loadTargetFile() {
        final List result = new ArrayList();
        try {
            final BufferedReader reader = new BufferedReader(new FileReader(getTargetTextFile()));
            for (String line = reader.readLine(); line != null; line = reader.readLine()) {
                line = line.trim();
                if (StringUtils.isEmpty(line))
                    continue;
                if (line.startsWith("#")) //'#' means comment
                    continue;
                if (result.contains(line))
                    continue;
                log.debug(getTargetTextFile() + " target: " + line);
                result.add(line);
            }
        } catch (IOException e) {
            throw new BuildException(e);
        }
        return result;
    }

    protected List initTargets() {
        final Properties properties = getDefaultProperties();
        final List source = loadTargetFile();
        final List result = new ArrayList();
        for (Iterator i = source.iterator(); i.hasNext();) {
            final String line = (String) i.next();
            final JoeyGenerateTarget target = createTarget(properties, line);
            result.add(target);
        }
        return result;
    }

    /**
     * @param properties
     * @param line
     * @return
     */
    private JoeyGenerateTarget createTarget(final Properties properties, final String line) {
        final String controlKey = "joey-gen.template.control." + line;
        final String destKey = "joey-gen.template.dest." + line;
        final String controlTemplate = String.valueOf(properties.getProperty(controlKey));
        final String targetStr = String.valueOf(properties.getProperty(destKey));
        try {
            final String destDir = getDestDir(targetStr);
            return new JoeyGenerateTarget(line, destDir, controlTemplate);
        } catch (BuildException e) {
            throw new BuildException("no destDir in property for '" + destKey + "'", e);
        }
    }

    private static final String DEFAULT_PROPERTIES_PATH = "org/asyrinx/joey/gen/ant/task/default.properties";

    private Properties getDefaultProperties() {
        final Properties properties = new Properties();
        final InputStream stream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_PROPERTIES_PATH);
        try {
            properties.load(stream);
        } catch (IOException e) {
            throw new BuildException(e);
        }
        return properties;
    }

    private String getDestDir(String targetStr) {
        if (targetStr == null)
            return getJavaSrcDir();
        if ("javasrc".equals(targetStr))
            return getJavaSrcDir();
        if ("testsrc".equals(targetStr))
            return getTestSrcDir();
        if ("proj".equals(targetStr))
            return getProjDir();
        if ("webapp".equals(targetStr))
            return getWebappDir();
        throw new BuildException("Illegal targetStr '" + targetStr + "'");
    }

    protected List filesets = new ArrayList();

    public void addFileset(FileSet set) {
        filesets.add(set);
    }

    public void setContextProperties(String file) {
        super.setContextProperties(file);
        final Map env = super.getProject().getProperties();
        for (Iterator i = env.keySet().iterator(); i.hasNext();) {
            final String key = (String) i.next();
            if (key.startsWith("joey-gen.")) {
                String newKey = toVelocityKey(key.substring("joey-gen.".length()));
                contextProperties.setProperty(newKey, env.get(key));
                log.debug("joey-gen property available: " + newKey + ":" + env.get(key));
            }
        }
        for (Iterator i = env.keySet().iterator(); i.hasNext();) {
            final String key = (String) i.next();
            if (key.startsWith("proj.")) {
                String newKey = toVelocityKey(key);
                contextProperties.setProperty(newKey, env.get(key));
                log.debug("project property available: " + newKey + ":" + env.get(key));
            }
        }
    }

    private String toVelocityKey(String newKey) {
        int j = newKey.indexOf(".");
        while (j != -1) {
            newKey = newKey.substring(0, j) + StringUtils.capitalize(newKey.substring(j + 1));
            j = newKey.indexOf(".");
        }
        return newKey;
    }

    private String targetTextFile = null;

    public String getTargetTextFile() {
        return targetTextFile;
    }

    public void setTargetTextFile(File targetTextFile) {
        try {
            this.targetTextFile = targetTextFile.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    private String projDir = null;

    private String javaSrcDir = null;

    private String testSrcDir = null;

    private String webappDir = null;

    public String getJavaSrcDir() {
        return javaSrcDir;
    }

    public String getProjDir() {
        return projDir;
    }

    public String getTestSrcDir() {
        return testSrcDir;
    }

    public String getWebappDir() {
        return webappDir;
    }

    public void setJavaSrcDir(File javaSrcDir) {
        try {
            this.javaSrcDir = javaSrcDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void setProjDir(File projDir) {
        try {
            this.projDir = projDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void setTestSrcDir(File testSrcDir) {
        try {
            this.testSrcDir = testSrcDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void setWebappDir(File webappDir) {
        try {
            this.webappDir = webappDir.getCanonicalPath();
        } catch (IOException e) {
            throw new BuildException(e);
        }
    }

    private File lastSchemaDir = null;

    public File getLastSchemaDir() {
        return lastSchemaDir;
    }

    public void setLastSchemaDir(File lastSchemaDir) {
        this.lastSchemaDir = lastSchemaDir;
    }
}

class SchemaBackup {

    public void execute(Project project, List sourceFileSets, File destDir) throws IOException {
        if (destDir.exists()) {
            FileUtils.cleanDirectory(destDir);
        } else {
            destDir.mkdirs();
        }
        copySchemaFiles(project, sourceFileSets, destDir);
    }

    /**
     * @param project
     * @param sourceFileSets
     * @param destDir
     * @throws IOException
     * @throws FileNotFoundException
     */
    private void copySchemaFiles(Project project, List sourceFileSets, File destDir) throws IOException,
            FileNotFoundException {
        for (int i = 0; i < sourceFileSets.size(); i++) {
            final FileSet fs = (FileSet) sourceFileSets.get(i);
            final File dir = fs.getDir(project);
            final DirectoryScanner ds = fs.getDirectoryScanner(project);
            final String[] filenNmes = ds.getIncludedFiles();
            for (int j = 0; j < filenNmes.length; j++) {
                final File src = new File(dir, filenNmes[j]);
                final File dest = new File(destDir, filenNmes[j]);
                CopyUtils.copy(new FileInputStream(src), new FileOutputStream(dest));
            }
        }
    }

}