/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/12 15:19:46
 */
package org.asyrinx.joey.gen.ant.task;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.asyrinx.brownie.core.lang.ObjectUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.ant.ModelLoader;
import org.asyrinx.joey.gen.command.rdb.StandardCommands;
import org.asyrinx.joey.gen.core.impl.S2ContainerLoader;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.ElementSet;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.command.Command;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;
import org.seasar.framework.container.S2Container;

/**
 * @author takeshi
 */
public class JoeyModificationTask extends Task {

    protected final Log log = LogFactory.getLog(this.getClass());

    protected List filesets = new ArrayList();

    public void addFileset(FileSet set) {
        filesets.add(set);
    }

    private S2Container container = S2ContainerLoader.getContainer();

    public void execute() throws BuildException {
        final ModelLoader modelLoader = (ModelLoader) container.getComponent(ModelLoader.class);
        try {
            final Databases currentModel = modelLoader.loadDatabaseModels(filesets, this.project);
            final Databases lastModel = modelLoader.loadDatabaseModels(getLastSchemaFileSets(), this.project);
            //`FbN
            final Command dbCommand = new StandardCommands();
            dbCommand.execute(currentModel);
            dbCommand.execute(lastModel);
            //\
            final ShowModification showModification = new ShowModification(this.isShowNoChange(), this.isShowDeleted(),
                    this.isShowAppended());
            showModification.execute(currentModel, lastModel);
        } catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private List getLastSchemaFileSets() {
        final List result = new ArrayList();
        final FileSet fs = new FileSet();
        fs.setDir(this.getLastSchemaDir());
        fs.setIncludes("*");
        result.add(fs);
        return result;
    }

    private File lastSchemaDir = null;

    public File getLastSchemaDir() {
        return lastSchemaDir;
    }

    public void setLastSchemaDir(File lastSchemaDir) {
        this.lastSchemaDir = lastSchemaDir;
    }

    private boolean showNoChange = true;

    private boolean showDeleted = true;

    private boolean showAppended = true;

    public boolean isShowAppended() {
        return showAppended;
    }

    public void setShowAppended(boolean showAppended) {
        this.showAppended = showAppended;
    }

    public boolean isShowDeleted() {
        return showDeleted;
    }

    public void setShowDeleted(boolean showDeleted) {
        this.showDeleted = showDeleted;
    }

    public boolean isShowNoChange() {
        return showNoChange;
    }

    public void setShowNoChange(boolean showNoChange) {
        this.showNoChange = showNoChange;
    }
}

interface ModificationView {
    void show(Element current, Element last);
}

class ShowModification {

    public ShowModification(boolean showNoChange, boolean showDeleted, boolean showAppended) {
        super();
        this.showNoChange = showNoChange;
        this.showDeleted = showDeleted;
        this.showAppended = showAppended;
    }

    private final boolean showNoChange;

    private final boolean showDeleted;

    private final boolean showAppended;

    //protected final Log log = LogFactory.getLog(this.getClass());

    private PrintWriter writer = getWriter(getOutputStream());

    /**
     * @param currentModel
     * @param lastModel
     */
    public void execute(Databases currentModel, Databases lastModel) {
        databasesView.show(currentModel, lastModel);
    }

    interface ShowClosure {
        void invoke(ModificationView view, String header, final Element lastElement, final Element currElement);
    }

    final ShowClosure lastBaseClosure = new ShowClosure() {
        public void invoke(ModificationView view, String header, final Element lastElement, final Element currElement) {
            if (currElement == null) {
                if (isShowDeleted())
                    printElementName("-", header, lastElement);
            } else if (currElement.equals(lastElement)) {
                if (isShowNoChange())
                    printElementName(" ", header, lastElement);
                if (view != null)
                    view.show(currElement, lastElement);
            } else {
                printElementName("!", header, lastElement);
                if (view != null)
                    view.show(currElement, lastElement);
            }
        }
    };

    final ShowClosure currentBaseClosure = new ShowClosure() {
        public void invoke(ModificationView view, String header, final Element lastElement, final Element currElement) {
            if (lastElement == null) {
                if (isShowAppended())
                    printElementName("+", header, currElement);
            }
        }
    };

    protected void showModification(ModificationView view, String header, ElementSet current, ElementSet last) {
        if (ObjectUtils.equals(current, last)) {
            if (!isShowNoChange())
                return;
        }
        if (current.careChildOrder())
            showModificationByOrder(view, header, current, last);
        else
            showModificationByName(view, header, current, last);
    }

    protected void showModificationByOrder(ModificationView view, String header, ElementSet current, ElementSet last) {
        for (int i = 0; i < last.size(); i++) {
            final Element lastElement = last.getElement(i);
            final Element currElement = current.getElement(i);
            lastBaseClosure.invoke(view, header, lastElement, currElement);
        }
        if (last.size() >= current.size())
            return;
        for (int i = last.size(); i < current.size(); i++) {
            final Element lastElement = null;
            final Element currElement = current.getElement(i);
            currentBaseClosure.invoke(view, header, lastElement, currElement);
        }
    }

    protected void showModificationByName(ModificationView view, String header, ElementSet current, ElementSet last) {
        for (Iterator i = last.iterator(); i.hasNext();) {
            final Element lastElement = (Element) i.next();
            final Element currElement = current.getElement(lastElement.getName());
            lastBaseClosure.invoke(view, header, lastElement, currElement);
        }
        for (Iterator i = current.iterator(); i.hasNext();) {
            final Element currElement = (Element) i.next();
            final Element lastElement = last.getElement(currElement.getName());
            currentBaseClosure.invoke(view, header, lastElement, currElement);
        }
    }

    void printElementName(String mark, String header, Element element) {
        if (element != null) {
            writer.println(mark + " " //
                    + StringUtils.repeat(" ", (element.getAncestorDepth() - 1) * 4) //
                    + StringUtils.padTail(header, " ", 12) // 
                    + " : " + element.getName());
        } else {
            writer.println(mark + " " //
                    + StringUtils.repeat(" ", 12) //
                    + StringUtils.padTail(header, " ", 12) // 
                    + " : " + "null");
        }
    }

    void printPropLine(Element element, String name, boolean last, boolean current) {
        printPropLine(element, name, new Boolean(last), new Boolean(current));
    }

    void printPropLine(Element element, String name, Object last, Object current) {
        final int indent = element.getAncestorDepth() * 4;
        if ((last instanceof Map) && (current instanceof Map)) {
            printPropLineAsMap(indent + 4, name, (Map) last, (Map) current);
        } else {
            printPropLine(indent, name, last, current);
        }
    }

    void printPropLine(int indent, String name, Object last, Object current) {
        if (ObjectUtils.equals(last, current)) {
            if (!isShowNoChange())
                return;
            writer.println(" " + " " // 
                    + StringUtils.repeat(" ", indent) //
                    + name + " : " + last);
        } else {
            writer.println("!" + " " // 
                    + StringUtils.repeat(" ", indent) //
                    + name + " : [" + last + "] -> [" + current + "]");
        }
    }

    void printPropLineAsMap(int indent, String name, Map last, Map current) {
        if (ObjectUtils.equals(last, current)) {
            if (!isShowNoChange())
                return;
            writer.println(" " + " " // 
                    + StringUtils.repeat(" ", indent) //
                    + name + " : ");
        } else {
            writer.println("!" + " " // 
                    + StringUtils.repeat(" ", indent) //
                    + name + " : ");
        }
        for (Iterator i = last.keySet().iterator(); i.hasNext();) {
            final Object key = i.next();
            final Object lastValue = last.get(key);
            final Object currValue = current.get(key);
            printPropLine(indent + 4, key.toString(), lastValue, currValue);
        }
        for (Iterator i = current.keySet().iterator(); i.hasNext();) {
            final Object key = i.next();
            if (last.containsKey(key)) {
                //łɏo͂ĂL[͏o͂Ȃ
                continue;
            }
            final Object lastValue = last.get(key);
            final Object currValue = current.get(key);
            printPropLine(indent + 4, key.toString(), lastValue, currValue);
        }
    }

    final ModificationView databasesView = new ModificationView() {
        public void show(Element current, Element last) {
            final Databases c = (Databases) current;
            final Databases l = (Databases) last;
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(databaseView, "database", c.getDatabases(), l.getDatabases());
        }
    };

    final ModificationView databaseView = new ModificationView() {
        public void show(Element current, Element last) {
            final Database c = (Database) current;
            final Database l = (Database) last;
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(enumView, "enum", c.getEnumerations(), l.getEnumerations());
            showModification(tableView, "table", c.getTables(), l.getTables());
        }
    };

    final ModificationView enumView = new ModificationView() {
        public void show(Element current, Element last) {
            final RdbEnumeration c = (RdbEnumeration) current;
            final RdbEnumeration l = (RdbEnumeration) last;
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(enumEntryView, "enum-entry", c, l);
        }
    };

    final ModificationView enumEntryView = new ModificationView() {
        public void show(Element current, Element last) {
            final EnumerationEntry c = (EnumerationEntry) current;
            final EnumerationEntry l = (EnumerationEntry) last;
            printPropLine(c, "value", l.getValue(), c.getValue());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
        }
    };

    final ModificationView tableView = new ModificationView() {
        public void show(Element current, Element last) {
            final Table c = (Table) current;
            final Table l = (Table) last;
            printPropLine(c, "extends", l.getExtends(), c.getExtends());
            printPropLine(c, "captionColumn", l.getCaptionColumn(), c.getCaptionColumn());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(columnView, "column", c.getColumns(), l.getColumns());
            showModification(fkView, "foreignKey", c.getForeignKeys(), l.getForeignKeys());
            showModification(indexView, "index", c.getIndexes(), l.getIndexes());
            showModification(patternView, "pattern", c.getPatterns(), l.getPatterns());
        }
    };

    final ModificationView columnView = new ModificationView() {
        public void show(Element current, Element last) {
            final Column c = (Column) current;
            final Column l = (Column) last;
            printPropLine(c, "type", l.getType(), c.getType());
            printPropLine(c, "size", l.getSize(), c.getSize());
            printPropLine(c, "required", l.isRequired(), c.isRequired());
            printPropLine(c, "primaryKey", l.isPrimaryKey(), c.isPrimaryKey());
            printPropLine(c, "defaultValue", l.getDefaultValue(), c.getDefaultValue());
            printPropLine(c, "enum", l.getEnum(), c.getEnum());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
        }
    };

    final ModificationView fkView = new ModificationView() {
        public void show(Element current, Element last) {
            final ForeignKey c = (ForeignKey) current;
            final ForeignKey l = (ForeignKey) last;
            printPropLine(c, "foreign", l.getForeign(), c.getForeign());
            printPropLine(c, "type", l.getType(), c.getType());
            printPropLine(c, "cascade", l.getCascade(), c.getCascade());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(fkEntryView, "reference", c, l);
        }
    };

    final ModificationView fkEntryView = new ModificationView() {
        public void show(Element current, Element last) {
            final ForeignKeyEntry c = (ForeignKeyEntry) current;
            final ForeignKeyEntry l = (ForeignKeyEntry) last;
            printPropLine(c, "local", l.getLocal(), c.getLocal());
            printPropLine(c, "foreign", l.getForeign(), c.getForeign());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
        }
    };

    final ModificationView indexView = new ModificationView() {
        public void show(Element current, Element last) {
            final Index c = (Index) current;
            final Index l = (Index) last;
            printPropLine(c, "unique", l.isUnique(), c.isUnique());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(indexEntryView, "index-column", c, l);
        }
    };

    final ModificationView uniqueView = new ModificationView() {
        public void show(Element current, Element last) {
            final Index c = (Index) current;
            final Index l = (Index) last;
            printPropLine(c, "unique", l.isUnique(), c.isUnique());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(indexEntryView, "unique-column", c, l);
        }
    };

    final ModificationView indexEntryView = new ModificationView() {
        public void show(Element current, Element last) {
            final IndexEntry c = (IndexEntry) current;
            final IndexEntry l = (IndexEntry) last;
            printPropLine(c, "options", l.getOptions(), c.getOptions());
        }
    };

    final ModificationView patternView = new ModificationView() {
        public void show(Element current, Element last) {
            final TablePattern c = (TablePattern) current;
            final TablePattern l = (TablePattern) last;
            printPropLine(c, "options", l.getOptions(), c.getOptions());
            showModification(patternParamView, "param", c, l);
        }
    };

    final ModificationView patternParamView = new ModificationView() {
        public void show(Element current, Element last) {
            final TablePatternParam c = (TablePatternParam) current;
            final TablePatternParam l = (TablePatternParam) last;
            printPropLine(c, "value", l.getValue(), c.getValue());
            printPropLine(c, "options", l.getOptions(), c.getOptions());
        }
    };

    protected OutputStream getOutputStream() {
        return System.out;
    }

    protected PrintWriter getWriter(OutputStream stream) {
        return new PrintWriter(stream) {
            public void println(String x) {
                System.out.println(x);
                //super.println(x);
            }
        };
    }

    public boolean isShowAppended() {
        return showAppended;
    }

    public boolean isShowDeleted() {
        return showDeleted;
    }

    public boolean isShowNoChange() {
        return showNoChange;
    }
}